/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigOverlay;
import org.apache.solr.core.ImplicitPlugins;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestParams;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaManager;
import org.apache.solr.util.CommandOperation;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.RTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrConfigHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CONFIGSET_EDITING_DISABLED_ARG = "disable.configEdit";
    public static final boolean configEditing_disabled = Boolean.getBoolean("disable.configEdit");
    private static final Map<String, SolrConfig.SolrPluginInfo> namedPlugins;
    private Lock reloadLock = new ReentrantLock(true);
    private boolean isImmutableConfigSet = false;
    private static Set<String> subPaths;
    public static final String SET_PROPERTY = "set-property";
    public static final String UNSET_PROPERTY = "unset-property";
    public static final String SET_USER_PROPERTY = "set-user-property";
    public static final String UNSET_USER_PROPERTY = "unset-user-property";
    public static final String SET = "set";
    public static final String UPDATE = "update";
    public static final String CREATE = "create";
    private static Set<String> cmdPrefixes;

    @Override
    public void init(NamedList args) {
        super.init(args);
        Object immutable = args.get("immutable");
        this.isImmutableConfigSet = immutable != null ? Boolean.parseBoolean(immutable.toString()) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrConfigHandler.setWt(req, "json");
        String httpMethod = (String)req.getContext().get("httpMethod");
        Command command = new Command(req, rsp, httpMethod);
        if ("POST".equals(httpMethod)) {
            if (configEditing_disabled || this.isImmutableConfigSet) {
                String reason = configEditing_disabled ? "due to disable.configEdit" : "because ConfigSet is immutable";
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, " solrconfig editing is not enabled " + reason);
            }
            try {
                command.handlePOST();
            }
            finally {
                RequestHandlerUtils.addExperimentalFormatWarning(rsp);
            }
        } else {
            command.handleGET();
        }
    }

    public static String validateName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.') continue;
            return StrUtils.formatString("''{0}'' name should only have chars [a-zA-Z_-.0-9] ", s);
        }
        return null;
    }

    public static void setWt(SolrQueryRequest req, String wt) {
        SolrParams params = req.getParams();
        if (params.get("wt") != null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("wt", wt);
        map.put("indent", "true");
        req.setParams(SolrParams.wrapDefaults(params, new MapSolrParams(map)));
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (subPaths.contains(path)) {
            return this;
        }
        if (path.startsWith("/params/")) {
            return this;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Edit solrconfig.xml";
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.OTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForAllReplicasState(String collection, ZkController zkController, String prop, int expectedVersion, int maxWaitSecs) {
        RTimer timer = new RTimer();
        ArrayList<PerReplicaCallable> concurrentTasks = new ArrayList<PerReplicaCallable>();
        for (String coreUrl : SolrConfigHandler.getActiveReplicaCoreUrls(zkController, collection)) {
            PerReplicaCallable e = new PerReplicaCallable(coreUrl, prop, expectedVersion, maxWaitSecs);
            concurrentTasks.add(e);
        }
        if (concurrentTasks.isEmpty()) {
            return;
        }
        log.info(StrUtils.formatString("Waiting up to {0} secs for {1} replicas to set the property {2} to be of version {3} for collection {4}", maxWaitSecs, concurrentTasks.size(), prop, expectedVersion, collection));
        int poolSize = Math.min(concurrentTasks.size(), 10);
        ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareFixedThreadPool(poolSize, new DefaultSolrThreadFactory("solrHandlerExecutor"));
        try {
            List results = parallelExecutor.invokeAll(concurrentTasks, maxWaitSecs, TimeUnit.SECONDS);
            ArrayList<String> failedList = null;
            for (int f = 0; f < results.size(); ++f) {
                Boolean success = false;
                Future next = results.get(f);
                if (next.isDone() && !next.isCancelled()) {
                    try {
                        success = (Boolean)next.get();
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                if (success.booleanValue()) continue;
                String coreUrl = ((PerReplicaCallable)concurrentTasks.get((int)f)).coreUrl;
                log.warn("Core " + coreUrl + "could not get the expected version " + expectedVersion);
                if (failedList == null) {
                    failedList = new ArrayList<String>();
                }
                failedList.add(coreUrl);
            }
            if (failedList != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, StrUtils.formatString("{0} out of {1} the property {2} to be of version {3} within {4} seconds! Failed cores: {5}", failedList.size(), concurrentTasks.size() + 1, prop, expectedVersion, maxWaitSecs, failedList));
            }
        }
        catch (InterruptedException ie) {
            log.warn(StrUtils.formatString("Core  was interrupted . trying to set the property {1} to version {2} to propagate to {3} replicas for collection {4}", prop, expectedVersion, concurrentTasks.size(), collection));
            Thread.currentThread().interrupt();
        }
        finally {
            ExecutorUtil.shutdownAndAwaitTermination(parallelExecutor);
        }
        log.info("Took {}ms to set the property {} to be of version {} for collection {}", new Object[]{timer.getTime(), prop, expectedVersion, collection});
    }

    public static List<String> getActiveReplicaCoreUrls(ZkController zkController, String collection) {
        ArrayList<String> activeReplicaCoreUrls = new ArrayList<String>();
        ClusterState clusterState = zkController.getZkStateReader().getClusterState();
        Set<String> liveNodes = clusterState.getLiveNodes();
        Collection<Slice> activeSlices = clusterState.getActiveSlices(collection);
        if (activeSlices != null && activeSlices.size() > 0) {
            for (Slice next : activeSlices) {
                Map<String, Replica> replicasMap = next.getReplicasMap();
                if (replicasMap == null) continue;
                for (Map.Entry<String, Replica> entry : replicasMap.entrySet()) {
                    Replica replica = entry.getValue();
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    activeReplicaCoreUrls.add(replica.getCoreUrl());
                }
            }
        }
        return activeReplicaCoreUrls;
    }

    static {
        HashMap<String, SolrConfig.SolrPluginInfo> map = new HashMap<String, SolrConfig.SolrPluginInfo>();
        for (SolrConfig.SolrPluginInfo plugin : SolrConfig.plugins) {
            if (!plugin.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_NAME) && !plugin.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_NAME_IN_OVERLAY)) continue;
            map.put(plugin.getCleanTag().toLowerCase(Locale.ROOT), plugin);
        }
        namedPlugins = Collections.unmodifiableMap(map);
        subPaths = new HashSet<String>(Arrays.asList("/overlay", "/params", "/updateHandler", "/query", "/jmx", "/requestDispatcher", "/znodeVersion"));
        for (SolrConfig.SolrPluginInfo solrPluginInfo : SolrConfig.plugins) {
            subPaths.add("/" + solrPluginInfo.getCleanTag());
        }
        cmdPrefixes = ImmutableSet.of((Object)CREATE, (Object)UPDATE, (Object)"delete", (Object)"add");
    }

    private static class PerReplicaCallable
    extends SolrRequest
    implements Callable<Boolean> {
        String coreUrl;
        String prop;
        int expectedZkVersion;
        Number remoteVersion = null;
        int maxWait;

        PerReplicaCallable(String coreUrl, String prop, int expectedZkVersion, int maxWait) {
            super(SolrRequest.METHOD.GET, "/config/znodeVersion");
            this.coreUrl = coreUrl;
            this.expectedZkVersion = expectedZkVersion;
            this.prop = prop;
            this.maxWait = maxWait;
        }

        @Override
        public SolrParams getParams() {
            return new ModifiableSolrParams().set(this.prop, this.expectedZkVersion).set("wt", "javabin");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() throws Exception {
            timer = new RTimer();
            attempts = 0;
            solr = new HttpSolrClient(this.coreUrl);
            var4_4 = null;
            while (true) {
                block18: {
                    try {
                        timeElapsed = (long)timer.getTime() / 1000L;
                        if (timeElapsed >= (long)this.maxWait) {
                            var7_9 = false;
                            if (solr == null) return var7_9;
                            if (var4_4 == null) break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) break;
                        SolrConfigHandler.access$300().warn("Failed to get /schema/zkversion from " + this.coreUrl + " due to: " + e);
                    }
                    catch (Throwable var5_8) {
                        try {
                            var4_4 = var5_8;
                            throw var5_8;
                        }
                        catch (Throwable var9_12) {
                            if (solr == null) throw var9_12;
                            if (var4_4 == null) {
                                solr.close();
                                throw var9_12;
                            }
                            try {
                                solr.close();
                                throw var9_12;
                            }
                            catch (Throwable x2) {
                                var4_4.addSuppressed(x2);
                                throw var9_12;
                            }
                        }
                    }
                    try {
                        solr.close();
                        return var7_9;
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                        return var7_9;
                    }
                }
                solr.close();
                return var7_9;
lbl-1000:
                // 1 sources

                {
                    SolrConfigHandler.access$300().info("Time elapsed : {} secs, maxWait {}", (Object)timeElapsed, (Object)this.maxWait);
                    Thread.sleep(100L);
                    resp = solr.httpUriRequest((SolrRequest)this).future.get();
                    if (resp != null && (m = (Map)resp.get("znodeVersion")) != null) {
                        this.remoteVersion = (Number)m.get(this.prop);
                        if (this.remoteVersion != null && this.remoteVersion.intValue() >= this.expectedZkVersion) break;
                    }
                    SolrConfigHandler.access$300().info(StrUtils.formatString("Could not get expectedVersion {0} from {1} for prop {2}   after {3} attempts", new Object[]{this.expectedZkVersion, this.coreUrl, this.prop, ++attempts}));
                }
            }
            if (solr == null) return true;
            if (var4_4 != null) {
                try {
                    solr.close();
                    return true;
                }
                catch (Throwable x2) {
                    var4_4.addSuppressed(x2);
                    return true;
                }
            }
            solr.close();
            return true;
        }

        @Override
        public Collection<ContentStream> getContentStreams() throws IOException {
            return null;
        }

        protected SolrResponse createResponse(SolrClient client) {
            return null;
        }
    }

    private class Command {
        private final SolrQueryRequest req;
        private final SolrQueryResponse resp;
        private final String method;
        private String path;
        List<String> parts;

        private Command(SolrQueryRequest req, SolrQueryResponse resp, String httpMethod) {
            this.req = req;
            this.resp = resp;
            this.method = httpMethod;
            this.path = (String)req.getContext().get("path");
            if (this.path == null) {
                this.path = this.getDefaultPath();
            }
            this.parts = StrUtils.splitSmart(this.path, '/');
            if (this.parts.get(0).isEmpty()) {
                this.parts.remove(0);
            }
        }

        private String getDefaultPath() {
            return "/config";
        }

        private void handleGET() {
            if (this.parts.size() == 1) {
                this.resp.add("config", this.getConfigDetails());
            } else if ("overlay".equals(this.parts.get(1))) {
                this.resp.add("overlay", this.req.getCore().getSolrConfig().getOverlay().toMap());
            } else if ("params".equals(this.parts.get(1))) {
                if (this.parts.size() == 3) {
                    RequestParams params = this.req.getCore().getSolrConfig().getRequestParams();
                    RequestParams.VersionedParams p = params.getParams(this.parts.get(2));
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    m.put("znodeVersion", params.getZnodeVersion());
                    if (p != null) {
                        m.put("params", Utils.makeMap(this.parts.get(2), p.getMap()));
                    }
                    this.resp.add("response", m);
                } else {
                    this.resp.add("response", this.req.getCore().getSolrConfig().getRequestParams().toMap());
                }
            } else if ("znodeVersion".equals(this.parts.get(1))) {
                this.resp.add("znodeVersion", Utils.makeMap("overlay", this.req.getCore().getSolrConfig().getOverlay().getZnodeVersion(), "params", this.req.getCore().getSolrConfig().getRequestParams().getZnodeVersion()));
                boolean checkStale = false;
                int expectedVersion = this.req.getParams().getInt("overlay", -1);
                int actualVersion = this.req.getCore().getSolrConfig().getOverlay().getZnodeVersion();
                if (expectedVersion > actualVersion) {
                    log.info("expecting overlay version {} but my version is {}", (Object)expectedVersion, (Object)actualVersion);
                    checkStale = true;
                } else if (expectedVersion != -1) {
                    log.info("I already have the expected version {} of config", (Object)expectedVersion);
                }
                expectedVersion = this.req.getParams().getInt("params", -1);
                actualVersion = this.req.getCore().getSolrConfig().getRequestParams().getZnodeVersion();
                if (expectedVersion > actualVersion) {
                    log.info("expecting params version {} but my version is {}", (Object)expectedVersion, (Object)actualVersion);
                    checkStale = true;
                } else if (expectedVersion != -1) {
                    log.info("I already have the expected version {} of params", (Object)expectedVersion);
                }
                if (checkStale && this.req.getCore().getResourceLoader() instanceof ZkSolrResourceLoader) {
                    new Thread(SolrConfigHandler.class.getSimpleName() + "-refreshconf"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (!SolrConfigHandler.this.reloadLock.tryLock()) {
                                log.info("Another reload is in progress . Not doing anything");
                                return;
                            }
                            try {
                                log.info("Trying to update my configs");
                                SolrCore.getConfListener(Command.this.req.getCore(), (ZkSolrResourceLoader)Command.this.req.getCore().getResourceLoader()).run();
                            }
                            catch (Exception e) {
                                log.error("Unable to refresh conf ", (Throwable)e);
                            }
                            finally {
                                SolrConfigHandler.this.reloadLock.unlock();
                            }
                        }
                    }.start();
                } else {
                    log.info("checkStale {} , resourceloader {}", (Object)checkStale, (Object)this.req.getCore().getResourceLoader().getClass().getName());
                }
            } else {
                Map<String, Object> m = this.getConfigDetails();
                this.resp.add("config", Utils.makeMap(this.parts.get(1), m.get(this.parts.get(1))));
            }
        }

        private Map<String, Object> getConfigDetails() {
            Map<String, Object> map = this.req.getCore().getSolrConfig().toMap();
            LinkedHashMap<String, Map<String, Object>> reqHandlers = (LinkedHashMap<String, Map<String, Object>>)map.get("requestHandler");
            if (reqHandlers == null) {
                reqHandlers = new LinkedHashMap<String, Map<String, Object>>();
                map.put("requestHandler", reqHandlers);
            }
            List<PluginInfo> plugins = ImplicitPlugins.getHandlers(this.req.getCore());
            for (PluginInfo plugin : plugins) {
                if (!"requestHandler".equals(plugin.type) || reqHandlers.containsKey(plugin.name)) continue;
                reqHandlers.put(plugin.name, plugin.toMap());
            }
            return map;
        }

        private void handlePOST() throws IOException {
            List<CommandOperation> ops = CommandOperation.readCommands(this.req.getContentStreams(), this.resp);
            if (ops == null) {
                return;
            }
            try {
                while (true) {
                    ArrayList<CommandOperation> opsCopy = new ArrayList<CommandOperation>(ops.size());
                    for (CommandOperation op : ops) {
                        opsCopy.add(op.getCopy());
                    }
                    try {
                        if (this.parts.size() > 1 && "params".equals(this.parts.get(1))) {
                            RequestParams params = RequestParams.getFreshRequestParams(this.req.getCore().getResourceLoader(), this.req.getCore().getSolrConfig().getRequestParams());
                            this.handleParams(opsCopy, params);
                        } else {
                            ConfigOverlay overlay = SolrConfig.getConfigOverlay(this.req.getCore().getResourceLoader());
                            this.handleCommands(opsCopy, overlay);
                        }
                    }
                    catch (ZkController.ResourceModifiedInZkException e) {
                        log.info("Race condition, the node is modified in ZK by someone else " + e.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.resp.setException(e);
                this.resp.add("errorMessages", Collections.singletonList(SchemaManager.getErrorStr(e)));
            }
        }

        private void handleParams(ArrayList<CommandOperation> ops, RequestParams params) {
            block11: for (CommandOperation op : ops) {
                switch (op.name) {
                    case "set": 
                    case "update": {
                        Map<String, Object> map = op.getDataMap();
                        if (op.hasError()) break;
                        for (Map.Entry entry : map.entrySet()) {
                            LinkedHashMap<String, String> val = null;
                            String key = (String)entry.getKey();
                            if (key == null || key.trim().isEmpty()) {
                                op.addError("null key ");
                                continue;
                            }
                            String err = SolrConfigHandler.validateName(key = key.trim());
                            if (err != null) {
                                op.addError(err);
                                continue;
                            }
                            try {
                                val = (LinkedHashMap<String, String>)entry.getValue();
                            }
                            catch (Exception e1) {
                                op.addError("invalid params for key : " + key);
                                continue;
                            }
                            if (val.containsKey("")) {
                                op.addError("Empty keys are not allowed in params");
                                continue;
                            }
                            RequestParams.VersionedParams old = params.getParams(key);
                            if (op.name.equals(SolrConfigHandler.UPDATE)) {
                                LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(old.getMap());
                                m.putAll((Map<String, String>)val);
                                val = m;
                            }
                            params = params.setParams(key, val);
                        }
                        continue block11;
                    }
                    case "delete": {
                        List<String> name = op.getStrs("");
                        if (op.hasError()) break;
                        for (String string : name) {
                            if (params.getParams(string) == null) {
                                op.addError(StrUtils.formatString("can't delete . No such params ''{0}'' exist", string));
                            }
                            params = params.setParams(string, null);
                        }
                        break;
                    }
                }
            }
            List<Map> errs = CommandOperation.captureErrors(ops);
            if (!errs.isEmpty()) {
                this.resp.add("errorMessages", errs);
                return;
            }
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                if (ops.isEmpty()) {
                    ZkController.touchConfDir(zkLoader);
                } else {
                    log.info("persisting params version : {}", params.toMap());
                    int latestVersion = ZkController.persistConfigResourceToZooKeeper(zkLoader, params.getZnodeVersion(), "params.json", params.toByteArray(), true);
                    SolrConfigHandler.waitForAllReplicasState(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName(), this.req.getCore().getCoreDescriptor().getCoreContainer().getZkController(), "params", latestVersion, 30);
                }
            } else {
                SolrResourceLoader.persistConfLocally(loader, "params.json", params.toByteArray());
                this.req.getCore().getSolrConfig().refreshRequestParams();
            }
        }

        private void handleCommands(List<CommandOperation> ops, ConfigOverlay overlay) throws IOException {
            block12: for (CommandOperation op : ops) {
                switch (op.name) {
                    case "set-property": {
                        overlay = this.applySetProp(op, overlay);
                        continue block12;
                    }
                    case "unset-property": {
                        overlay = this.applyUnset(op, overlay);
                        continue block12;
                    }
                    case "set-user-property": {
                        overlay = this.applySetUserProp(op, overlay);
                        continue block12;
                    }
                    case "unset-user-property": {
                        overlay = this.applyUnsetUserProp(op, overlay);
                        continue block12;
                    }
                }
                List<String> pcs = StrUtils.splitSmart(op.name.toLowerCase(Locale.ROOT), '-');
                if (pcs.size() != 2) {
                    op.addError(StrUtils.formatString("Unknown operation ''{0}'' ", op.name));
                    continue;
                }
                String prefix = pcs.get(0);
                String name = pcs.get(1);
                if (cmdPrefixes.contains(prefix) && namedPlugins.containsKey(name)) {
                    SolrConfig.SolrPluginInfo info = (SolrConfig.SolrPluginInfo)namedPlugins.get(name);
                    if ("delete".equals(prefix)) {
                        overlay = this.deleteNamedComponent(op, overlay, info.getCleanTag());
                        continue;
                    }
                    overlay = this.updateNamedPlugin(info, op, overlay, prefix.equals(SolrConfigHandler.CREATE) || prefix.equals("add"));
                    continue;
                }
                op.unknownOperation();
            }
            List<Map> errs = CommandOperation.captureErrors(ops);
            if (!errs.isEmpty()) {
                log.info("Failed to run commands. errors are {}", (Object)StrUtils.join(errs, ','));
                this.resp.add("errorMessages", errs);
                return;
            }
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                int latestVersion = ZkController.persistConfigResourceToZooKeeper((ZkSolrResourceLoader)loader, overlay.getZnodeVersion(), "configoverlay.json", overlay.toByteArray(), true);
                log.info("Executed config commands successfully and persisted to ZK {}", ops);
                SolrConfigHandler.waitForAllReplicasState(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName(), this.req.getCore().getCoreDescriptor().getCoreContainer().getZkController(), "overlay", latestVersion, 30);
            } else {
                SolrResourceLoader.persistConfLocally(loader, "configoverlay.json", overlay.toByteArray());
                this.req.getCore().getCoreDescriptor().getCoreContainer().reload(this.req.getCore().getName());
                log.info("Executed config commands successfully and persited to File System {}", ops);
            }
        }

        private ConfigOverlay deleteNamedComponent(CommandOperation op, ConfigOverlay overlay, String typ) {
            String name = op.getStr("");
            if (op.hasError()) {
                return overlay;
            }
            if (overlay.getNamedPlugins(typ).containsKey(name)) {
                return overlay.deleteNamedPlugin(name, typ);
            }
            op.addError(StrUtils.formatString("NO such {0} ''{1}'' ", typ, name));
            return overlay;
        }

        private ConfigOverlay updateNamedPlugin(SolrConfig.SolrPluginInfo info, CommandOperation op, ConfigOverlay overlay, boolean isCeate) {
            String name = op.getStr("name");
            String clz = info.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_CLASS) ? op.getStr("class") : op.getStr("class", null);
            op.getMap("defaults", null);
            op.getMap("invariants", null);
            op.getMap("appends", null);
            if (op.hasError()) {
                return overlay;
            }
            if (!this.verifyClass(op, clz, info.clazz)) {
                return overlay;
            }
            if (this.pluginExists(info, overlay, name)) {
                if (isCeate) {
                    op.addError(StrUtils.formatString(" ''{0}'' already exists . Do an ''{1}'' , if you want to change it ", name, "update-" + info.getTagCleanLower()));
                    return overlay;
                }
                return overlay.addNamedPlugin(op.getDataMap(), info.getCleanTag());
            }
            if (isCeate) {
                return overlay.addNamedPlugin(op.getDataMap(), info.getCleanTag());
            }
            op.addError(StrUtils.formatString(" ''{0}'' does not exist . Do an ''{1}'' , if you want to create it ", name, "create-" + info.getTagCleanLower()));
            return overlay;
        }

        private boolean pluginExists(SolrConfig.SolrPluginInfo info, ConfigOverlay overlay, String name) {
            List<PluginInfo> l = this.req.getCore().getSolrConfig().getPluginInfos(info.clazz.getName());
            for (PluginInfo pluginInfo : l) {
                if (!name.equals(pluginInfo.name)) continue;
                return true;
            }
            return overlay.getNamedPlugins(info.getCleanTag()).containsKey(name);
        }

        private boolean verifyClass(CommandOperation op, String clz, Class expected) {
            if (clz == null) {
                return true;
            }
            if (!"true".equals(String.valueOf(op.getStr("runtimeLib", null)))) {
                try {
                    this.req.getCore().createInitInstance(new PluginInfo("requestHandler", op.getDataMap()), expected, clz, "");
                }
                catch (Exception e) {
                    op.addError(e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private ConfigOverlay applySetUserProp(CommandOperation op, ConfigOverlay overlay) {
            Map<String, Object> m = op.getDataMap();
            if (op.hasError()) {
                return overlay;
            }
            for (Map.Entry<String, Object> e : m.entrySet()) {
                String name = e.getKey();
                Object val = e.getValue();
                overlay = overlay.setUserProperty(name, val);
            }
            return overlay;
        }

        private ConfigOverlay applyUnsetUserProp(CommandOperation op, ConfigOverlay overlay) {
            List<String> name = op.getStrs("");
            if (op.hasError()) {
                return overlay;
            }
            for (String o : name) {
                if (!overlay.getUserProps().containsKey(o)) {
                    op.addError(StrUtils.formatString("No such property ''{0}''", name));
                    continue;
                }
                overlay = overlay.unsetUserProperty(o);
            }
            return overlay;
        }

        private ConfigOverlay applyUnset(CommandOperation op, ConfigOverlay overlay) {
            List<String> name = op.getStrs("");
            if (op.hasError()) {
                return overlay;
            }
            for (String o : name) {
                if (!ConfigOverlay.isEditableProp(o, false, null)) {
                    op.addError(StrUtils.formatString("''{0}'' is not an editable property", name));
                    continue;
                }
                overlay = overlay.unsetProperty(o);
            }
            return overlay;
        }

        private ConfigOverlay applySetProp(CommandOperation op, ConfigOverlay overlay) {
            Map<String, Object> m = op.getDataMap();
            if (op.hasError()) {
                return overlay;
            }
            for (Map.Entry<String, Object> e : m.entrySet()) {
                Object val;
                String name;
                block14: {
                    name = e.getKey();
                    val = e.getValue();
                    Class typ = ConfigOverlay.checkEditable(name, false, null);
                    if (typ == null) {
                        op.addError(StrUtils.formatString("''{0}'' is not an editable property", name));
                        continue;
                    }
                    if (val != null) {
                        if (typ == String.class) {
                            val = val.toString();
                        }
                        String typeErr = "Property {0} must be of {1} type ";
                        if (typ == Boolean.class) {
                            try {
                                val = Boolean.parseBoolean(val.toString());
                                break block14;
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, name, typ.getSimpleName()));
                                continue;
                            }
                        }
                        if (typ == Integer.class) {
                            try {
                                val = Integer.parseInt(val.toString());
                                break block14;
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, typ.getSimpleName()));
                                continue;
                            }
                        }
                        if (typ == Float.class) {
                            try {
                                val = Float.valueOf(Float.parseFloat(val.toString()));
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, typ.getSimpleName()));
                                continue;
                            }
                        }
                    }
                }
                overlay = overlay.setProperty(name, val);
            }
            return overlay;
        }
    }
}

