/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.hash.HashFunction;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.hll.HLL;
import org.apache.solr.util.hll.HLLType;

abstract class AbstractStatsValues<T>
implements StatsValues {
    private static final String FACETS = "facets";
    protected final StatsField statsField;
    protected final SchemaField sf;
    protected final FieldType ft;
    protected final boolean computeCount;
    protected final boolean computeMissing;
    protected final boolean computeCalcDistinct;
    protected final boolean computeMin;
    protected final boolean computeMax;
    protected final boolean computeMinOrMax;
    protected final boolean computeCardinality;
    private ValueSource valueSource;
    private Map vsContext;
    protected FunctionValues values;
    protected T max;
    protected T min;
    protected long missing;
    protected long count;
    protected long countDistinct;
    protected final Set<T> distinctValues;
    protected final HashFunction hasher;
    private HLL hll;
    protected Map<String, Map<String, StatsValues>> facets = new HashMap<String, Map<String, StatsValues>>();

    protected AbstractStatsValues(StatsField statsField) {
        this.statsField = statsField;
        this.computeCount = statsField.calculateStats(StatsField.Stat.count);
        this.computeMissing = statsField.calculateStats(StatsField.Stat.missing);
        this.computeCalcDistinct = statsField.calculateStats(StatsField.Stat.countDistinct) || statsField.calculateStats(StatsField.Stat.distinctValues);
        this.computeMin = statsField.calculateStats(StatsField.Stat.min);
        this.computeMax = statsField.calculateStats(StatsField.Stat.max);
        this.computeMinOrMax = this.computeMin || this.computeMax;
        this.distinctValues = this.computeCalcDistinct ? new TreeSet() : null;
        this.computeCardinality = statsField.calculateStats(StatsField.Stat.cardinality);
        if (this.computeCardinality) {
            this.hasher = statsField.getHllOptions().getHasher();
            this.hll = statsField.getHllOptions().newHLL();
            assert (null != this.hll) : "Cardinality requires an HLL";
        } else {
            this.hll = null;
            this.hasher = null;
        }
        if (null != statsField.getSchemaField()) {
            assert (null == statsField.getValueSource());
            this.sf = statsField.getSchemaField();
            this.ft = this.sf.getType();
        } else {
            assert (null != statsField.getValueSource());
            assert (null == statsField.getSchemaField());
            this.sf = null;
            this.ft = null;
        }
    }

    @Override
    public void accumulate(NamedList stv) {
        if (this.computeCount) {
            this.count += ((Long)stv.get("count")).longValue();
        }
        if (this.computeMissing) {
            this.missing += ((Long)stv.get("missing")).longValue();
        }
        if (this.computeCalcDistinct) {
            this.distinctValues.addAll((Collection)stv.get("distinctValues"));
            this.countDistinct = this.distinctValues.size();
        }
        if (this.computeMinOrMax) {
            this.updateMinMax(stv.get("min"), stv.get("max"));
        }
        if (this.computeCardinality) {
            byte[] data = (byte[])stv.get("cardinality");
            HLL other = HLL.fromBytes(data);
            if (this.hll.getType().equals((Object)HLLType.EMPTY)) {
                this.hll = other;
            } else {
                this.hll.union(other);
            }
        }
        this.updateTypeSpecificStats(stv);
        NamedList f = (NamedList)stv.get(FACETS);
        if (f == null) {
            return;
        }
        for (int i = 0; i < f.size(); ++i) {
            String field = f.getName(i);
            NamedList vals = (NamedList)f.getVal(i);
            Map<String, StatsValues> addTo = this.facets.get(field);
            if (addTo == null) {
                addTo = new HashMap<String, StatsValues>();
                this.facets.put(field, addTo);
            }
            for (int j = 0; j < vals.size(); ++j) {
                String val = vals.getName(j);
                StatsValues vvals = addTo.get(val);
                if (vvals == null) {
                    vvals = StatsValuesFactory.createStatsValues(this.statsField);
                    addTo.put(val, vvals);
                }
                vvals.accumulate((NamedList)vals.getVal(j));
            }
        }
    }

    @Override
    public void accumulate(BytesRef value, int count) {
        if (null == this.ft) {
            throw new IllegalStateException("Can't collect & convert BytesRefs on stats that do't use a a FieldType: " + this.statsField);
        }
        Object typedValue = this.ft.toObject(this.sf, value);
        this.accumulate(typedValue, count);
    }

    public void accumulate(T value, int count) {
        assert (null != value) : "Can't accumulate null";
        if (this.computeCount) {
            this.count += (long)count;
        }
        if (this.computeCalcDistinct) {
            this.distinctValues.add(value);
            this.countDistinct = this.distinctValues.size();
        }
        if (this.computeMinOrMax) {
            this.updateMinMax(value, value);
        }
        if (this.computeCardinality) {
            if (null == this.hasher) {
                assert (value instanceof Number) : "pre-hashed value support only works with numeric longs";
                this.hll.addRaw(((Number)value).longValue());
            } else {
                this.hll.addRaw(this.hash(value));
            }
        }
        this.updateTypeSpecificStats(value, count);
    }

    @Override
    public void missing() {
        if (this.computeMissing) {
            ++this.missing;
        }
    }

    @Override
    public void addMissing(int count) {
        this.missing += (long)count;
    }

    @Override
    public void addFacet(String facetName, Map<String, StatsValues> facetValues) {
        this.facets.put(facetName, facetValues);
    }

    @Override
    public NamedList<?> getStatsValues() {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        if (this.statsField.includeInResponse(StatsField.Stat.min)) {
            res.add("min", this.min);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.max)) {
            res.add("max", this.max);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.count)) {
            res.add("count", this.count);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.missing)) {
            res.add("missing", this.missing);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.distinctValues)) {
            res.add("distinctValues", this.distinctValues);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.countDistinct)) {
            res.add("countDistinct", this.countDistinct);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.cardinality)) {
            if (this.statsField.getIsShard()) {
                res.add("cardinality", this.hll.toBytes());
            } else {
                res.add("cardinality", this.hll.cardinality());
            }
        }
        this.addTypeSpecificStats(res);
        if (!this.facets.isEmpty()) {
            SimpleOrderedMap nl = new SimpleOrderedMap();
            for (Map.Entry<String, Map<String, StatsValues>> entry : this.facets.entrySet()) {
                SimpleOrderedMap nl2 = new SimpleOrderedMap();
                nl.add(entry.getKey(), nl2);
                for (Map.Entry<String, StatsValues> e2 : entry.getValue().entrySet()) {
                    nl2.add(e2.getKey(), e2.getValue().getStatsValues());
                }
            }
            res.add(FACETS, nl);
        }
        return res;
    }

    @Override
    public void setNextReader(LeafReaderContext ctx) throws IOException {
        if (this.valueSource == null) {
            this.valueSource = null == this.ft ? this.statsField.getValueSource() : this.ft.getValueSource(this.sf, null);
            this.vsContext = ValueSource.newContext(this.statsField.getSearcher());
        }
        this.values = this.valueSource.getValues(this.vsContext, ctx);
    }

    protected abstract long hash(T var1);

    protected abstract void updateMinMax(T var1, T var2);

    protected abstract void updateTypeSpecificStats(T var1, int var2);

    protected abstract void updateTypeSpecificStats(NamedList var1);

    protected abstract void addTypeSpecificStats(NamedList<Object> var1);
}

