/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.util.SolrPluginUtils;

public class DebugComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "debug";
    private static final AtomicLong ridCounter = new AtomicLong();
    private static final Map<Integer, String> stages;
    private static final Set<String> EXCLUDE_SET;

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.isDebugTrack() && rb.isDistrib) {
            this.doDebugTrack(rb);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.isDebug()) {
            DocList results = null;
            if (rb.getResults() != null) {
                results = rb.getResults().docList;
            }
            NamedList stdinfo = SolrPluginUtils.doStandardDebug(rb.req, rb.getQueryString(), rb.wrap(rb.getQuery()), results, rb.isDebugQuery(), rb.isDebugResults());
            NamedList info = rb.getDebugInfo();
            if (info == null) {
                rb.setDebugInfo(stdinfo);
                info = stdinfo;
            } else {
                info.addAll(stdinfo);
            }
            FacetDebugInfo fdebug = (FacetDebugInfo)rb.req.getContext().get("FacetDebugInfo");
            if (fdebug != null) {
                info.add("facet-trace", fdebug.getFacetDebugInfo());
            }
            if (rb.req.getJSON() != null) {
                info.add("json", rb.req.getJSON());
            }
            if (rb.isDebugQuery() && rb.getQparser() != null) {
                rb.getQparser().addDebugInfo(rb.getDebugInfo());
            }
            if (null != rb.getDebugInfo()) {
                if (rb.isDebugQuery() && null != rb.getFilters()) {
                    info.add("filter_queries", rb.req.getParams().getParams("fq"));
                    ArrayList<String> fqs = new ArrayList<String>(rb.getFilters().size());
                    for (Query fq : rb.getFilters()) {
                        fqs.add(QueryParsing.toString(fq, rb.req.getSchema()));
                    }
                    info.add("parsed_filter_queries", fqs);
                }
                rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
            }
        }
    }

    private void doDebugTrack(ResponseBuilder rb) {
        SolrQueryRequest req = rb.req;
        String rid = req.getParams().get("rid");
        if (rid == null || "".equals(rid)) {
            rid = this.generateRid(rb);
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.add("rid", rid);
            req.setParams(params);
        }
        rb.addDebug(rid, "track", "rid");
        rb.rsp.addToLog("rid", rid);
    }

    @SuppressForbidden(reason="Need currentTimeMillis, only used for naming")
    private String generateRid(ResponseBuilder rb) {
        String hostName = rb.req.getCore().getCoreDescriptor().getCoreContainer().getHostName();
        return hostName + "-" + rb.req.getCore().getName() + "-" + System.currentTimeMillis() + "-" + ridCounter.getAndIncrement();
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.isDebug()) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x100;
            if (rb.isDebugAll()) {
                sreq.params.set("debugQuery", "true");
            } else {
                if (rb.isDebugQuery()) {
                    sreq.params.add(COMPONENT_NAME, "query");
                }
                if (rb.isDebugResults()) {
                    sreq.params.add(COMPONENT_NAME, "results");
                }
            }
        } else {
            sreq.params.set("debugQuery", "false");
            sreq.params.set(COMPONENT_NAME, "false");
        }
        if (rb.isDebugTimings()) {
            sreq.params.add(COMPONENT_NAME, "timing");
        }
        if (rb.isDebugTrack()) {
            sreq.params.add(COMPONENT_NAME, "track");
            sreq.params.set("rid", rb.req.getParams().get("rid"));
            sreq.params.set("requestPurpose", SolrPluginUtils.getRequestPurpose(sreq.purpose));
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (rb.isDebugTrack() && rb.isDistrib && !rb.finished.isEmpty()) {
            SimpleOrderedMap<NamedList<String>> stageList = (SimpleOrderedMap<NamedList<String>>)((NamedList)rb.getDebugInfo().get("track")).get(stages.get(rb.stage));
            if (stageList == null) {
                stageList = new SimpleOrderedMap<NamedList<String>>();
                rb.addDebug(stageList, "track", stages.get(rb.stage));
            }
            for (ShardResponse response : sreq.responses) {
                stageList.add(response.getShard(), this.getTrackResponse(response));
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.isDebug() && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            NamedList info = rb.getDebugInfo();
            NamedList explain = new SimpleOrderedMap();
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            boolean hasGetDebugResponses = false;
            for (ShardRequest sreq : rb.finished) {
                for (ShardResponse srsp : sreq.responses) {
                    if (srsp.getException() != null) continue;
                    NamedList sdebug = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                    info = (NamedList)this.merge(sdebug, info, EXCLUDE_SET);
                    if ((sreq.purpose & 0x100) == 0) continue;
                    hasGetDebugResponses = true;
                    if (!rb.isDebugResults()) continue;
                    NamedList sexplain = (NamedList)sdebug.get("explain");
                    SolrPluginUtils.copyNamedListIntoArrayByDocPosInResponse(sexplain, rb.resultIds, arr);
                }
            }
            if (rb.isDebugResults()) {
                explain = SolrPluginUtils.removeNulls(arr, new SimpleOrderedMap());
            }
            if (!hasGetDebugResponses) {
                if (info == null) {
                    info = new SimpleOrderedMap<Object>();
                }
                SolrPluginUtils.doStandardQueryDebug(rb.req, rb.getQueryString(), rb.wrap(rb.getQuery()), rb.isDebugQuery(), info);
                if (rb.isDebugQuery() && rb.getQparser() != null) {
                    rb.getQparser().addDebugInfo(info);
                }
            }
            if (rb.isDebugResults()) {
                int idx = info.indexOf("explain", 0);
                if (idx >= 0) {
                    info.setVal(idx, explain);
                } else {
                    info.add("explain", explain);
                }
            }
            rb.setDebugInfo(info);
            rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
        }
    }

    private NamedList<String> getTrackResponse(ShardResponse shardResponse) {
        SimpleOrderedMap<String> namedList = new SimpleOrderedMap<String>();
        if (shardResponse.getException() != null) {
            namedList.add("Exception", shardResponse.getException().getMessage());
            return namedList;
        }
        NamedList<Object> responseNL = shardResponse.getSolrResponse().getResponse();
        NamedList responseHeader = (NamedList)responseNL.get("responseHeader");
        if (responseHeader != null) {
            namedList.add("QTime", responseHeader.get("QTime").toString());
        }
        namedList.add("ElapsedTime", String.valueOf(shardResponse.getSolrResponse().getElapsedTime()));
        namedList.add("RequestPurpose", shardResponse.getShardRequest().params.get("requestPurpose"));
        SolrDocumentList docList = (SolrDocumentList)shardResponse.getSolrResponse().getResponse().get("response");
        if (docList != null) {
            namedList.add("NumFound", String.valueOf(docList.getNumFound()));
        }
        namedList.add("Response", String.valueOf(responseNL));
        return namedList;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object merge(Object source, Object dest2222, Set<String> exclude) {
        void dest2222;
        if (source == null) {
            return dest2222;
        }
        if (dest2222 == null) {
            if (!(source instanceof NamedList)) return source;
            NamedList dest2222 = source instanceof SimpleOrderedMap ? new SimpleOrderedMap() : new NamedList();
        } else {
            Cloneable dest2222;
            if (dest2222 instanceof Collection) {
                void dest2222;
                if (!(dest2222 instanceof Set)) {
                    LinkedHashSet dest2222 = new LinkedHashSet((Collection)((Object)dest2222));
                }
                if (source instanceof Collection) {
                    ((Collection)dest2222).addAll((Collection)source);
                    return dest2222;
                } else {
                    ((Collection)dest2222).add(source);
                }
                return dest2222;
            }
            if (source instanceof Number) {
                if (dest2222 instanceof Number) {
                    if (!(source instanceof Double) && !(dest2222 instanceof Double)) return ((Number)source).longValue() + ((Number)((Object)dest2222)).longValue();
                    return ((Number)source).doubleValue() + ((Number)((Object)dest2222)).doubleValue();
                }
            } else if (source instanceof String && source.equals(dest2222)) {
                return dest2222;
            }
        }
        if (source instanceof NamedList && dest2222 instanceof NamedList) {
            NamedList<Object> tmp = new NamedList<Object>();
            NamedList sl = (NamedList)source;
            NamedList dl = (NamedList)dest2222;
            for (int i = 0; i < sl.size(); ++i) {
                String dkey;
                String skey = sl.getName(i);
                if (exclude.contains(skey)) continue;
                Object sval = sl.getVal(i);
                int didx = -1;
                if (i < dl.size() && (skey == (dkey = dl.getName(i)) || skey != null && skey.equals(dkey))) {
                    didx = i;
                }
                if (didx == -1) {
                    didx = dl.indexOf(skey, 0);
                }
                if (didx == -1) {
                    tmp.add(skey, this.merge(sval, null, Collections.emptySet()));
                    continue;
                }
                dl.setVal(didx, this.merge(sval, dl.getVal(didx), Collections.emptySet()));
            }
            dl.addAll(tmp);
            return dl;
        }
        if (source.equals(dest2222)) {
            return source;
        }
        ArrayList<Object> t = new ArrayList<Object>();
        t.add(dest2222);
        t.add(source);
        return t;
    }

    @Override
    public String getDescription() {
        return "Debug Information";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    static {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(ResponseBuilder.STAGE_START, "START");
        map.put(ResponseBuilder.STAGE_PARSE_QUERY, "PARSE_QUERY");
        map.put(ResponseBuilder.STAGE_TOP_GROUPS, "TOP_GROUPS");
        map.put(ResponseBuilder.STAGE_EXECUTE_QUERY, "EXECUTE_QUERY");
        map.put(ResponseBuilder.STAGE_GET_FIELDS, "GET_FIELDS");
        map.put(ResponseBuilder.STAGE_DONE, "DONE");
        stages = Collections.unmodifiableMap(map);
        EXCLUDE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("explain")));
    }
}

