/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

final class OffsetWindowTokenFilter
extends TokenFilter {
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int windowStartOffset;
    private int windowEndOffset = -1;
    private boolean windowTokenIncremented = false;
    private boolean inputWasReset = false;
    private AttributeSource.State capturedState;

    OffsetWindowTokenFilter(TokenStream input) {
        super(input);
    }

    OffsetWindowTokenFilter advanceToNextWindowOfLength(int length) {
        this.windowStartOffset = this.windowEndOffset + 1;
        this.windowEndOffset = this.windowStartOffset + length;
        this.windowTokenIncremented = false;
        return this;
    }

    @Override
    public void reset() throws IOException {
        if (this.windowTokenIncremented) {
            throw new IllegalStateException("This TokenStream does not support being subsequently reset()");
        }
        if (!this.inputWasReset) {
            super.reset();
            this.inputWasReset = true;
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        int endOffset;
        int startOffset;
        assert (this.inputWasReset);
        this.windowTokenIncremented = true;
        do {
            if (this.capturedState == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
            } else {
                this.restoreState(this.capturedState);
                this.capturedState = null;
                this.posIncAtt.setPositionIncrement(1);
            }
            startOffset = this.offsetAtt.startOffset();
            endOffset = this.offsetAtt.endOffset();
            if (startOffset < this.windowEndOffset) continue;
            this.capturedState = this.captureState();
            return false;
        } while (startOffset < this.windowStartOffset);
        this.offsetAtt.setOffset(startOffset - this.windowStartOffset, endOffset - this.windowStartOffset);
        return true;
    }
}

