/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.io.IOException;
import org.noggit.JSONParser;

public class JSONUtil {
    public static boolean advanceToMapKey(JSONParser parser, String key, boolean deepSearch) throws IOException {
        block6: while (true) {
            int event = parser.nextEvent();
            switch (event) {
                case 1: {
                    if (key == null || !parser.wasKey()) continue block6;
                    String val = parser.getString();
                    if (!key.equals(val)) continue block6;
                    return true;
                }
                case 8: {
                    return false;
                }
                case 7: {
                    if (deepSearch) {
                        boolean found = JSONUtil.advanceToMapKey(parser, key, true);
                        if (!found) continue block6;
                        return true;
                    }
                    JSONUtil.advanceToMapKey(parser, null, false);
                    break;
                }
                case 9: {
                    JSONUtil.skipArray(parser, key, deepSearch);
                }
            }
        }
    }

    public static void skipArray(JSONParser parser, String key, boolean deepSearch) throws IOException {
        while (true) {
            int event = parser.nextEvent();
            switch (event) {
                case 7: {
                    JSONUtil.advanceToMapKey(parser, key, deepSearch);
                    break;
                }
                case 9: {
                    JSONUtil.skipArray(parser, key, deepSearch);
                    break;
                }
                case 10: {
                    return;
                }
            }
        }
    }

    public static void expect(JSONParser parser, int parserEventType) throws IOException {
        int event = parser.nextEvent();
        if (event != parserEventType) {
            throw new IOException("JSON Parser: expected " + JSONParser.getEventString(parserEventType) + " but got " + JSONParser.getEventString(event));
        }
    }
}

