/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;

public class DocsStreamer
implements Iterator<SolrDocument> {
    private static final Set<Class> KNOWN_TYPES = new HashSet<Class>();
    private final DocList docs;
    private SolrIndexSearcher searcher;
    private final IndexSchema schema;
    private DocTransformer transformer;
    private DocIterator docIterator;
    private boolean onlyPseudoFields;
    private Set<String> fnames;
    private TransformContext context;
    private Set<String> dvFieldsToReturn;
    private int idx = -1;

    public DocsStreamer(DocList docList, Query query, SolrQueryRequest req, ReturnFields returnFields) {
        this.docs = docList;
        this.schema = req.getSchema();
        this.searcher = req.getSearcher();
        this.transformer = returnFields.getTransformer();
        this.docIterator = docList.iterator();
        this.context = new TransformContext();
        this.context.query = query;
        this.context.wantsScores = returnFields.wantsScore() && docList.hasScores();
        this.context.req = req;
        this.context.searcher = this.searcher;
        this.context.iterator = this.docIterator;
        this.fnames = returnFields.getLuceneFieldNames();
        boolean bl = this.onlyPseudoFields = this.fnames == null && !returnFields.wantsAllFields() && !returnFields.hasPatternMatching() || this.fnames != null && this.fnames.size() == 1 && "score".equals(this.fnames.iterator().next());
        if (returnFields.wantsAllFields()) {
            Set<String> fieldNames = returnFields.getLuceneFieldNames(true);
            if (fieldNames == null || fieldNames.isEmpty()) {
                this.dvFieldsToReturn = this.searcher.getNonStoredDVs(true);
            } else {
                this.dvFieldsToReturn = new HashSet<String>(this.searcher.getNonStoredDVs(true));
                for (String fl : fieldNames) {
                    if (!this.searcher.getNonStoredDVs(false).contains(fl)) continue;
                    this.dvFieldsToReturn.add(fl);
                }
            }
        } else if (returnFields.hasPatternMatching()) {
            for (String s : this.searcher.getNonStoredDVs(true)) {
                if (!returnFields.wantsField(s)) continue;
                if (null == this.dvFieldsToReturn) {
                    this.dvFieldsToReturn = new HashSet<String>();
                }
                this.dvFieldsToReturn.add(s);
            }
        } else if (this.fnames != null) {
            this.dvFieldsToReturn = new HashSet<String>(this.fnames);
            this.dvFieldsToReturn.retainAll(this.searcher.getNonStoredDVs(false));
        }
        if (this.transformer != null) {
            this.transformer.setContext(this.context);
        }
    }

    public boolean hasScores() {
        return this.context.wantsScores;
    }

    public int currentIndex() {
        return this.idx;
    }

    @Override
    public boolean hasNext() {
        return this.docIterator.hasNext();
    }

    @Override
    public SolrDocument next() {
        int id = this.docIterator.nextDoc();
        ++this.idx;
        SolrDocument sdoc = null;
        if (this.onlyPseudoFields) {
            sdoc = new SolrDocument();
        } else {
            try {
                Document doc = this.searcher.doc(id, this.fnames);
                sdoc = DocsStreamer.getDoc(doc, this.schema);
                if (this.dvFieldsToReturn != null) {
                    this.searcher.decorateDocValueFields(sdoc, id, this.dvFieldsToReturn);
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading document with docId " + id, (Throwable)e);
            }
        }
        if (this.transformer != null) {
            try {
                this.transformer.transform(sdoc, id);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error applying transformer", (Throwable)e);
            }
        }
        return sdoc;
    }

    public static SolrDocument getDoc(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get(f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), f);
                continue;
            }
            out.addField(f.name(), f);
        }
        return out;
    }

    @Override
    public void remove() {
    }

    public static Object getValue(SchemaField sf, IndexableField f) {
        FieldType ft = null;
        if (sf != null) {
            ft = sf.getType();
        }
        if (ft == null) {
            BytesRef bytesRef = f.binaryValue();
            if (bytesRef != null) {
                if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
                    return bytesRef.bytes;
                }
                byte[] bytes = new byte[bytesRef.length];
                System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
                return bytes;
            }
            return f.stringValue();
        }
        if (KNOWN_TYPES.contains(ft.getClass())) {
            return ft.toObject(f);
        }
        return ft.toExternal(f);
    }

    static {
        KNOWN_TYPES.add(BoolField.class);
        KNOWN_TYPES.add(StrField.class);
        KNOWN_TYPES.add(TextField.class);
        KNOWN_TYPES.add(TrieField.class);
        KNOWN_TYPES.add(TrieIntField.class);
        KNOWN_TYPES.add(TrieLongField.class);
        KNOWN_TYPES.add(TrieFloatField.class);
        KNOWN_TYPES.add(TrieDoubleField.class);
        KNOWN_TYPES.add(TrieDateField.class);
        KNOWN_TYPES.add(BinaryField.class);
    }
}

