/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Date;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.util.DateFormatUtil;

class TrieDateFieldSource
extends LongFieldSource {
    public TrieDateFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "date(" + this.field + ')';
    }

    @Override
    protected MutableValueLong newMutableValueLong() {
        return new MutableValueDate();
    }

    @Override
    public Date longToObject(long val) {
        return new Date(val);
    }

    @Override
    public String longToString(long val) {
        return DateFormatUtil.formatExternal(this.longToObject(val));
    }

    @Override
    public long externalToLong(String extVal) {
        return DateFormatUtil.parseMath(null, extVal).getTime();
    }
}

