/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;

public class TrieFloatField
extends TrieField
implements FloatValueFieldType {
    public TrieFloatField() {
        this.type = TrieField.TrieTypes.FLOAT;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof String) {
            return Float.valueOf(Float.parseFloat((String)val));
        }
        return super.toNativeType(val);
    }

    @Override
    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField f) {
        return new SortedSetFieldSource(f.getName(), choice){

            @Override
            public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
                1 thisAsSortedSetFieldSource = this;
                SortedSetDocValues sortedSet = DocValues.getSortedSet(readerContext.reader(), this.field);
                final SortedDocValues view = SortedSetSelector.wrap(sortedSet, this.selector);
                return new FloatDocValues(thisAsSortedSetFieldSource){

                    @Override
                    public float floatVal(int doc) {
                        BytesRef bytes = view.get(doc);
                        if (0 == bytes.length) {
                            assert (!this.exists(doc)) : "zero bytes for doc, but exists is true";
                            return 0.0f;
                        }
                        return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(bytes));
                    }

                    @Override
                    public boolean exists(int doc) {
                        return -1 != view.getOrd(doc);
                    }

                    @Override
                    public FunctionValues.ValueFiller getValueFiller() {
                        return new FunctionValues.ValueFiller(){
                            private final MutableValueFloat mval = new MutableValueFloat();

                            @Override
                            public MutableValue getValue() {
                                return this.mval;
                            }

                            @Override
                            public void fillValue(int doc) {
                                BytesRef bytes = view.get(doc);
                                this.mval.exists = 0 == bytes.length;
                                this.mval.value = this.mval.exists ? NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(bytes)) : 0.0f;
                            }
                        };
                    }
                };
            }
        };
    }
}

