/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.SortedIntDocSet;

public class DocSetCollector
extends SimpleCollector {
    int pos = 0;
    FixedBitSet bits;
    final int maxDoc;
    final int smallSetSize;
    int base;
    final int[] scratch;

    public DocSetCollector(int maxDoc) {
        this(DocSetUtil.smallSetSize(maxDoc), maxDoc);
    }

    public DocSetCollector(int smallSetSize, int maxDoc) {
        this.smallSetSize = smallSetSize;
        this.maxDoc = maxDoc;
        this.scratch = new int[smallSetSize];
    }

    @Override
    public void collect(int doc) throws IOException {
        doc += this.base;
        if (this.pos < this.scratch.length) {
            this.scratch[this.pos] = doc;
        } else {
            if (this.bits == null) {
                this.bits = new FixedBitSet(this.maxDoc);
            }
            this.bits.set(doc);
        }
        ++this.pos;
    }

    public DocSet getDocSet() {
        if (this.pos <= this.scratch.length) {
            return new SortedIntDocSet(this.scratch, this.pos);
        }
        for (int i = 0; i < this.scratch.length; ++i) {
            this.bits.set(this.scratch[i]);
        }
        return new BitDocSet(this.bits, this.pos);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.base = context.docBase;
    }
}

