/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.DocSet;

class FilterImpl
extends Filter {
    final DocSet filter;
    final Filter topFilter;
    final List<Weight> weights;

    public FilterImpl(DocSet filter, List<Weight> weights) {
        this.filter = filter;
        this.weights = weights;
        this.topFilter = filter == null ? null : filter.getTopFilter();
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet sub;
        DocIdSet docIdSet = sub = this.topFilter == null ? null : this.topFilter.getDocIdSet(context, acceptDocs);
        if (this.weights.size() == 0) {
            return sub;
        }
        return new FilterSet(sub, context);
    }

    @Override
    public String toString(String field) {
        return "SolrFilter";
    }

    private static class DualFilterIterator
    extends DocIdSetIterator {
        final DocIdSetIterator a;
        final DocIdSetIterator b;

        public DualFilterIterator(DocIdSetIterator a, DocIdSetIterator b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public int docID() {
            return this.a.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int other;
            int doc = this.a.nextDoc();
            do {
                if ((other = this.b.advance(doc)) != doc) continue;
                return doc;
            } while (other != (doc = this.a.advance(other)));
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int other;
            int doc = this.a.advance(target);
            do {
                if ((other = this.b.advance(doc)) != doc) continue;
                return doc;
            } while (other != (doc = this.a.advance(other)));
            return doc;
        }

        @Override
        public long cost() {
            return Math.min(this.a.cost(), this.b.cost());
        }
    }

    private static class FilterIterator
    extends DocIdSetIterator {
        final DocIdSetIterator[] iterators;
        final DocIdSetIterator first;

        public FilterIterator(DocIdSetIterator[] iterators) {
            this.iterators = iterators;
            this.first = iterators[0];
        }

        @Override
        public int docID() {
            return this.first.docID();
        }

        private int doNext(int doc) throws IOException {
            int which = 0;
            int i = 1;
            while (i < this.iterators.length) {
                DocIdSetIterator iter;
                int next;
                if (i != which && (next = (iter = this.iterators[i]).advance(doc)) != doc) {
                    doc = next;
                    which = i;
                    i = 0;
                    continue;
                }
                ++i;
            }
            return doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.doNext(this.first.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            return this.doNext(this.first.advance(target));
        }

        @Override
        public long cost() {
            return this.first.cost();
        }
    }

    private class FilterSet
    extends DocIdSet {
        DocIdSet docIdSet;
        LeafReaderContext context;

        public FilterSet(DocIdSet docIdSet, LeafReaderContext context) {
            this.docIdSet = docIdSet;
            this.context = context;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>(FilterImpl.this.weights.size() + 1);
            if (this.docIdSet != null) {
                DocIdSetIterator iter = this.docIdSet.iterator();
                if (iter == null) {
                    return null;
                }
                iterators.add(iter);
            }
            for (Weight w : FilterImpl.this.weights) {
                Scorer scorer = w.scorer(this.context);
                if (scorer == null) {
                    return null;
                }
                iterators.add(scorer.iterator());
            }
            if (iterators.size() == 0) {
                return null;
            }
            if (iterators.size() == 1) {
                return (DocIdSetIterator)iterators.get(0);
            }
            if (iterators.size() == 2) {
                return new DualFilterIterator((DocIdSetIterator)iterators.get(0), (DocIdSetIterator)iterators.get(1));
            }
            return new FilterIterator(iterators.toArray(new DocIdSetIterator[iterators.size()]));
        }

        @Override
        public Bits bits() throws IOException {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return this.docIdSet != null ? this.docIdSet.ramBytesUsed() : 0L;
        }
    }
}

