/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LRUCache.class);
    static final long DEFAULT_RAM_BYTES_USED = 192L;
    static final long HASHTABLE_RAM_BYTES_PER_ENTRY = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2;
    static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    private CumulativeStats stats;
    private long lookups;
    private long hits;
    private long inserts;
    private long evictions;
    private long evictionsRamUsage;
    private long warmupTime = 0L;
    private Map<K, V> map;
    private String description = "LRU Cache";
    private long maxRamBytes = Long.MAX_VALUE;
    private long ramBytesUsed = 0L;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        final int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        int initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), limit);
        str = (String)args.get("maxRamMB");
        this.maxRamBytes = str == null ? Long.MAX_VALUE : (long)(Double.parseDouble(str) * 1024.0 * 1024.0);
        final long maxRamBytes = this.maxRamBytes;
        this.description = this.generateDescription(limit, initialSize);
        this.map = new LinkedHashMap<K, V>(initialSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > limit || LRUCache.this.ramBytesUsed > maxRamBytes) {
                    if (maxRamBytes != Long.MAX_VALUE && LRUCache.this.ramBytesUsed > maxRamBytes) {
                        long bytesToDecrement = 0L;
                        Iterator iterator = this.entrySet().iterator();
                        do {
                            Map.Entry entry;
                            if ((entry = iterator.next()).getKey() != null) {
                                bytesToDecrement = entry.getKey() instanceof Accountable ? (bytesToDecrement += ((Accountable)entry.getKey()).ramBytesUsed()) : (bytesToDecrement += 192L);
                            }
                            if (entry.getValue() != null) {
                                bytesToDecrement += ((Accountable)entry.getValue()).ramBytesUsed();
                            }
                            LRUCache.this.ramBytesUsed -= (bytesToDecrement += LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
                            iterator.remove();
                            LRUCache.this.evictions++;
                            LRUCache.this.evictionsRamUsage++;
                            ((LRUCache)LRUCache.this).stats.evictions.incrementAndGet();
                            ((LRUCache)LRUCache.this).stats.evictionsRamUsage.incrementAndGet();
                        } while (iterator.hasNext() && LRUCache.this.ramBytesUsed > maxRamBytes);
                        return false;
                    }
                    LRUCache.this.evictions++;
                    ((LRUCache)LRUCache.this).stats.evictions.incrementAndGet();
                    return true;
                }
                return false;
            }
        };
        if (persistence == null) {
            persistence = new CumulativeStats();
        }
        this.stats = (CumulativeStats)persistence;
        return persistence;
    }

    private String generateDescription(int limit, int initialSize) {
        String description = "LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        if (this.maxRamBytes != Long.MAX_VALUE) {
            description = description + ", maxRamMB=" + this.maxRamBytes / 1024L / 1024L;
        }
        description = description + ')';
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.getState() == SolrCache.State.LIVE) {
                this.stats.inserts.incrementAndGet();
            }
            ++this.inserts;
            long keySize = 192L;
            if (this.maxRamBytes != Long.MAX_VALUE) {
                if (key != null && key instanceof Accountable) {
                    keySize = ((Accountable)key).ramBytesUsed();
                }
                long valueSize = 0L;
                if (value != null) {
                    if (value instanceof Accountable) {
                        Accountable accountable = (Accountable)value;
                        valueSize = accountable.ramBytesUsed();
                    } else {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cache: " + this.getName() + " is configured with maxRamBytes=" + RamUsageEstimator.humanReadableUnits(this.maxRamBytes) + " but its values do not implement org.apache.lucene.util.Accountable");
                    }
                }
                this.ramBytesUsed += keySize + valueSize + LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
            V old = this.map.put(key, value);
            if (this.maxRamBytes != Long.MAX_VALUE && old != null) {
                long bytesToDecrement = ((Accountable)old).ramBytesUsed();
                bytesToDecrement += LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
                if (key != null) {
                    if (key instanceof Accountable) {
                        Accountable aKey = (Accountable)key;
                        bytesToDecrement += aKey.ramBytesUsed();
                    } else {
                        bytesToDecrement += 192L;
                    }
                }
                this.ramBytesUsed -= bytesToDecrement;
            }
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            V val = this.map.get(key);
            if (this.getState() == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.incrementAndGet();
                if (val != null) {
                    ++this.hits;
                    this.stats.hits.incrementAndGet();
                }
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
            this.ramBytesUsed = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        LRUCache other = (LRUCache)old;
        if (this.isAutowarmingOn()) {
            Object[] keys;
            Object[] vals = null;
            Map<K, V> map = other.map;
            synchronized (map) {
                int i;
                int sz = this.autowarm.getWarmCount(other.map.size());
                keys = new Object[sz];
                vals = new Object[sz];
                Iterator<Map.Entry<K, V>> iter = other.map.entrySet().iterator();
                int skip = other.map.size() - sz;
                for (i = 0; i < skip; ++i) {
                    iter.next();
                }
                for (i = 0; i < sz; ++i) {
                    Map.Entry<K, V> entry = iter.next();
                    keys[i] = entry.getKey();
                    vals[i] = entry.getValue();
                }
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, keys[i], vals[i]);
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log(log, "Error during auto-warming of key:" + keys[i], e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return LRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap<Number> lst = new SimpleOrderedMap<Number>();
        Map<K, V> map = this.map;
        synchronized (map) {
            lst.add("lookups", this.lookups);
            lst.add("hits", this.hits);
            lst.add("hitratio", Float.valueOf(LRUCache.calcHitRatio(this.lookups, this.hits)));
            lst.add("inserts", this.inserts);
            lst.add("evictions", this.evictions);
            lst.add("size", this.map.size());
            if (this.maxRamBytes != Long.MAX_VALUE) {
                lst.add("maxRamMB", this.maxRamBytes / 1024L / 1024L);
                lst.add("ramBytesUsed", this.ramBytesUsed());
                lst.add("evictionsRamUsage", this.evictionsRamUsage);
            }
        }
        lst.add("warmupTime", this.warmupTime);
        long clookups = this.stats.lookups.get();
        long chits = this.stats.hits.get();
        lst.add("cumulative_lookups", clookups);
        lst.add("cumulative_hits", chits);
        lst.add("cumulative_hitratio", Float.valueOf(LRUCache.calcHitRatio(clookups, chits)));
        lst.add("cumulative_inserts", this.stats.inserts.get());
        lst.add("cumulative_evictions", this.stats.evictions.get());
        if (this.maxRamBytes != Long.MAX_VALUE) {
            lst.add("cumulative_evictionsRamUsage", this.stats.evictionsRamUsage.get());
        }
        return lst;
    }

    public String toString() {
        return this.name() + this.getStatistics().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return BASE_RAM_BYTES_USED + this.ramBytesUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        if (this.maxRamBytes != Long.MAX_VALUE) {
            Map<K, V> map = this.map;
            synchronized (map) {
                return Accountables.namedAccountables(this.getName(), this.map);
            }
        }
        return Collections.emptyList();
    }

    private static class CumulativeStats {
        AtomicLong lookups = new AtomicLong();
        AtomicLong hits = new AtomicLong();
        AtomicLong inserts = new AtomicLong();
        AtomicLong evictions = new AtomicLong();
        AtomicLong evictionsRamUsage = new AtomicLong();

        private CumulativeStats() {
        }
    }
}

