/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;

public class SimpleQParserPlugin
extends QParserPlugin {
    public static final String NAME = "simple";
    private static final Map<String, Integer> OPERATORS = new HashMap<String, Integer>();

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new SimpleQParser(qstr, localParams, params, req);
    }

    static {
        OPERATORS.put("AND", 1);
        OPERATORS.put("NOT", 2);
        OPERATORS.put("OR", 4);
        OPERATORS.put("PREFIX", 8);
        OPERATORS.put("PHRASE", 16);
        OPERATORS.put("PRECEDENCE", 32);
        OPERATORS.put("ESCAPE", 64);
        OPERATORS.put("WHITESPACE", 128);
        OPERATORS.put("FUZZY", 256);
        OPERATORS.put("NEAR", 512);
    }

    private static class SolrSimpleQueryParser
    extends SimpleQueryParser {
        QParser qParser;
        IndexSchema schema;

        public SolrSimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, QParser qParser, IndexSchema schema) {
            super(analyzer, weights, flags);
            this.qParser = qParser;
            this.schema = schema;
        }

        @Override
        protected Query newPrefixQuery(String text) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.setDisableCoord(true);
            for (Map.Entry entry : this.weights.entrySet()) {
                Query prefix;
                String field = (String)entry.getKey();
                FieldType type = this.schema.getFieldType(field);
                if (type instanceof TextField) {
                    Analyzer analyzer = ((TextField)type).getMultiTermAnalyzer();
                    String term = TextField.analyzeMultiTerm(field, text, analyzer).utf8ToString();
                    SchemaField sf = this.schema.getField(field);
                    prefix = sf.getType().getPrefixQuery(this.qParser, sf, term);
                } else {
                    SchemaField sf = this.schema.getField(field);
                    prefix = type.getPrefixQuery(this.qParser, sf, text);
                }
                float boost = ((Float)entry.getValue()).floatValue();
                if (boost != 1.0f) {
                    prefix = new BoostQuery(prefix, boost);
                }
                bq.add(prefix, BooleanClause.Occur.SHOULD);
            }
            return this.simplify(bq.build());
        }

        @Override
        protected Query newFuzzyQuery(String text, int fuzziness) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.setDisableCoord(true);
            for (Map.Entry entry : this.weights.entrySet()) {
                Query fuzzy;
                String field = (String)entry.getKey();
                FieldType type = this.schema.getFieldType(field);
                if (type instanceof TextField) {
                    Analyzer analyzer = ((TextField)type).getMultiTermAnalyzer();
                    String term = TextField.analyzeMultiTerm(field, text, analyzer).utf8ToString();
                    fuzzy = new FuzzyQuery(new Term((String)entry.getKey(), term), fuzziness);
                } else {
                    fuzzy = new FuzzyQuery(new Term((String)entry.getKey(), text), fuzziness);
                }
                float boost = ((Float)entry.getValue()).floatValue();
                if (boost != 1.0f) {
                    fuzzy = new BoostQuery(fuzzy, boost);
                }
                bq.add(fuzzy, BooleanClause.Occur.SHOULD);
            }
            return this.simplify(bq.build());
        }
    }

    private static class SimpleQParser
    extends QParser {
        private SimpleQueryParser parser;

        public SimpleQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
            SolrParams defaultParams = SolrParams.wrapDefaults(localParams, params);
            Map<String, Float> queryFields = SolrPluginUtils.parseFieldBoosts(defaultParams.get("qf"));
            if (queryFields.isEmpty()) {
                String defaultField = QueryParsing.getDefaultField(req.getSchema(), defaultParams.get("df"));
                if (defaultField == null) {
                    throw new IllegalStateException("Neither qf, df, nor the default search field are present.");
                }
                queryFields.put(defaultField, Float.valueOf(1.0f));
            } else {
                for (Map.Entry<String, Float> queryField : queryFields.entrySet()) {
                    if (queryField.getValue() != null) continue;
                    queryField.setValue(Float.valueOf(1.0f));
                }
            }
            int enabledOps = 0;
            String opParam = defaultParams.get("q.operators");
            if (opParam == null) {
                enabledOps = -1;
            } else {
                String[] operations;
                for (String operation : operations = opParam.split(",")) {
                    Integer enabledOp = (Integer)OPERATORS.get(operation.trim().toUpperCase(Locale.ROOT));
                    if (enabledOp == null) continue;
                    enabledOps |= enabledOp.intValue();
                }
            }
            IndexSchema schema = req.getSchema();
            this.parser = new SolrSimpleQueryParser(req.getSchema().getQueryAnalyzer(), queryFields, enabledOps, this, schema);
            QueryParser.Operator defaultOp = QueryParsing.getQueryParserDefaultOperator(req.getSchema(), defaultParams.get("q.op"));
            if (defaultOp == QueryParser.Operator.AND) {
                this.parser.setDefaultOperator(BooleanClause.Occur.MUST);
            }
        }

        @Override
        public Query parse() throws SyntaxError {
            return this.parser.parse(this.qstr);
        }
    }
}

