/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.CountSlotArrAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortSlotAcc;
import org.apache.solr.search.facet.SpecialSlotAcc;

abstract class FacetFieldProcessor
extends FacetProcessor<FacetField> {
    SchemaField sf;
    SlotAcc indexOrderAcc;
    int effectiveMincount;
    Map<String, AggValueSource> deferredAggs;
    SlotAcc collectAcc;
    SlotAcc sortAcc;
    SlotAcc[] otherAccs;
    SpecialSlotAcc allBucketsAcc;

    FacetFieldProcessor(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq);
        this.sf = sf;
        this.effectiveMincount = (int)(fcontext.isShard() ? Math.min(1L, freq.mincount) : freq.mincount);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void createAccs(int docCount, int slotCount) throws IOException {
        if (this.accMap == null) {
            this.accMap = new LinkedHashMap();
        }
        if (this.countAcc == null) {
            this.countAcc = new CountSlotArrAcc(this.fcontext, slotCount);
            this.countAcc.key = "count";
        }
        if (this.accs != null) {
            for (SlotAcc acc : this.accs) {
                acc.reset();
            }
            return;
        }
        this.accs = new SlotAcc[((FacetField)this.freq).getFacetStats().size()];
        int accIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : ((FacetField)this.freq).getFacetStats().entrySet()) {
            SlotAcc acc = null;
            if (slotCount == 1 && (acc = (SlotAcc)this.accMap.get(entry.getKey())) != null) {
                acc.reset();
            }
            if (acc == null) {
                acc = entry.getValue().createSlotAcc(this.fcontext, docCount, slotCount);
                acc.key = entry.getKey();
                this.accMap.put(acc.key, acc);
            }
            this.accs[accIdx++] = acc;
        }
    }

    void createCollectAcc(int numDocs, int numSlots) throws IOException {
        boolean needOtherAccs;
        this.accMap = new LinkedHashMap();
        if (this.countAcc == null) {
            this.countAcc = new CountSlotArrAcc(this.fcontext, numSlots);
        }
        if ("count".equals(((FacetField)this.freq).sortVariable)) {
            this.sortAcc = this.countAcc;
            this.deferredAggs = ((FacetField)this.freq).getFacetStats();
        } else if ("index".equals(((FacetField)this.freq).sortVariable)) {
            if (this.indexOrderAcc == null) {
                this.indexOrderAcc = new SortSlotAcc(this.fcontext);
            }
            this.sortAcc = this.indexOrderAcc;
            this.deferredAggs = ((FacetField)this.freq).getFacetStats();
        } else {
            AggValueSource sortAgg = ((FacetField)this.freq).getFacetStats().get(((FacetField)this.freq).sortVariable);
            if (sortAgg != null) {
                this.collectAcc = sortAgg.createSlotAcc(this.fcontext, numDocs, numSlots);
                this.collectAcc.key = ((FacetField)this.freq).sortVariable;
            }
            this.sortAcc = this.collectAcc;
            this.deferredAggs = new HashMap<String, AggValueSource>(((FacetField)this.freq).getFacetStats());
            this.deferredAggs.remove(((FacetField)this.freq).sortVariable);
        }
        if (this.deferredAggs.size() == 0) {
            this.deferredAggs = null;
        }
        if (!(needOtherAccs = ((FacetField)this.freq).allBuckets)) {
            return;
        }
        this.createOtherAccs(numDocs, 1);
    }

    void createOtherAccs(int numDocs, int numSlots) throws IOException {
        int numDeferred;
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.reset();
            }
            return;
        }
        int n = numDeferred = this.deferredAggs == null ? 0 : this.deferredAggs.size();
        if (numDeferred <= 0) {
            return;
        }
        this.otherAccs = new SlotAcc[numDeferred];
        int otherAccIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : this.deferredAggs.entrySet()) {
            AggValueSource agg = entry.getValue();
            SlotAcc acc = agg.createSlotAcc(this.fcontext, numDocs, numSlots);
            acc.key = entry.getKey();
            this.accMap.put(acc.key, acc);
            this.otherAccs[otherAccIdx++] = acc;
        }
        if (numDeferred == ((FacetField)this.freq).getFacetStats().size()) {
            this.accs = this.otherAccs;
        }
    }

    int collectFirstPhase(DocSet docs, int slot) throws IOException {
        int num = -1;
        if (this.collectAcc != null) {
            num = this.collectAcc.collect(docs, slot);
        }
        if (this.allBucketsAcc != null) {
            num = this.allBucketsAcc.collect(docs, slot);
        }
        return num >= 0 ? num : docs.size();
    }

    void collectFirstPhase(int segDoc, int slot) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.collect(segDoc, slot);
        }
        if (this.allBucketsAcc != null) {
            this.allBucketsAcc.collect(segDoc, slot);
        }
    }

    void fillBucket(SimpleOrderedMap<Object> target, int count, int slotNum, DocSet subDomain, Query filter) throws IOException {
        target.add("count", count);
        if (count <= 0 && !((FacetField)this.freq).processEmpty) {
            return;
        }
        if (this.collectAcc != null && slotNum >= 0) {
            this.collectAcc.setValues(target, slotNum);
        }
        this.createOtherAccs(-1, 1);
        if (this.otherAccs == null && ((FacetField)this.freq).subFacets.isEmpty()) {
            return;
        }
        if (subDomain == null) {
            subDomain = this.fcontext.searcher.getDocSet(filter, this.fcontext.base);
        }
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.reset();
                acc.collect(subDomain, 0);
                acc.setValues(target, 0);
            }
        }
        this.processSubs(target, filter, subDomain);
    }

    @Override
    protected void processStats(SimpleOrderedMap<Object> bucket, DocSet docs, int docCount) throws IOException {
        if (docCount == 0 && !((FacetField)this.freq).processEmpty || ((FacetField)this.freq).getFacetStats().size() == 0) {
            bucket.add("count", docCount);
            return;
        }
        this.createAccs(docCount, 1);
        int collected = this.collect(docs, 0);
        assert (collected == docCount);
        this.addStats(bucket, collected, 0);
    }

    void addStats(SimpleOrderedMap<Object> target, int count, int slotNum) throws IOException {
        target.add("count", count);
        if (count > 0 || ((FacetField)this.freq).processEmpty) {
            for (SlotAcc acc : this.accs) {
                acc.setValues(target, slotNum);
            }
        }
    }

    @Override
    void setNextReader(LeafReaderContext ctx) throws IOException {
        super.setNextReader(ctx);
    }

    void setNextReaderFirstPhase(LeafReaderContext ctx) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.setNextReader(ctx);
        }
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.setNextReader(ctx);
            }
        }
    }

    static class Slot {
        int slot;

        Slot() {
        }

        public int tiebreakCompare(int slotA, int slotB) {
            return slotB - slotA;
        }
    }
}

