/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Insanity;
import org.apache.solr.search.SolrIndexSearcher;

public class OrdFieldSource
extends ValueSource {
    protected final String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public OrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "ord(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader r;
        final int off = readerContext.docBase;
        Object o = context.get("searcher");
        if (o instanceof SolrIndexSearcher) {
            SolrIndexSearcher is = (SolrIndexSearcher)o;
            SchemaField sf = is.getSchema().getFieldOrNull(this.field);
            if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumericType() != null) {
                List<LeafReaderContext> leaves = is.getIndexReader().leaves();
                IndexReader[] insaneLeaves = new LeafReader[leaves.size()];
                int upto = 0;
                for (LeafReaderContext raw : leaves) {
                    insaneLeaves[upto++] = Insanity.wrapInsanity(raw.reader(), this.field);
                }
                r = SlowCompositeReaderWrapper.wrap(new MultiReader(insaneLeaves));
            } else {
                r = ((SolrIndexSearcher)o).getLeafReader();
            }
        } else {
            IndexReader topReader = ReaderUtil.getTopLevelContext(readerContext).reader();
            r = SlowCompositeReaderWrapper.wrap(topReader);
        }
        final SortedDocValues sindex = SortedSetSelector.wrap(DocValues.getSortedSet(r, this.field), SortedSetSelector.Type.MIN);
        return new IntDocValues(this){

            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public int intVal(int doc) {
                return sindex.getOrd(doc + off);
            }

            @Override
            public int ordVal(int doc) {
                return sindex.getOrd(doc + off);
            }

            @Override
            public int numOrd() {
                return sindex.getValueCount();
            }

            @Override
            public boolean exists(int doc) {
                return sindex.getOrd(doc + off) != 0;
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = sindex.getOrd(doc);
                        this.mval.exists = this.mval.value != 0;
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o.getClass() == OrdFieldSource.class && this.field.equals(((OrdFieldSource)o).field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

