/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Insanity;
import org.apache.solr.search.SolrIndexSearcher;

public class ReverseOrdFieldSource
extends ValueSource {
    public final String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "rord(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader r;
        final int off = readerContext.docBase;
        Object o = context.get("searcher");
        if (o instanceof SolrIndexSearcher) {
            SolrIndexSearcher is = (SolrIndexSearcher)o;
            SchemaField sf = is.getSchema().getFieldOrNull(this.field);
            if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumericType() != null) {
                List<LeafReaderContext> leaves = is.getIndexReader().leaves();
                IndexReader[] insaneLeaves = new LeafReader[leaves.size()];
                int upto = 0;
                for (LeafReaderContext raw : leaves) {
                    insaneLeaves[upto++] = Insanity.wrapInsanity(raw.reader(), this.field);
                }
                r = SlowCompositeReaderWrapper.wrap(new MultiReader(insaneLeaves));
            } else {
                r = ((SolrIndexSearcher)o).getLeafReader();
            }
        } else {
            IndexReader topReader = ReaderUtil.getTopLevelContext(readerContext).reader();
            r = SlowCompositeReaderWrapper.wrap(topReader);
        }
        final SortedDocValues sindex = SortedSetSelector.wrap(DocValues.getSortedSet(r, this.field), SortedSetSelector.Type.MIN);
        final int end = sindex.getValueCount();
        return new IntDocValues(this){

            @Override
            public int intVal(int doc) {
                return end - sindex.getOrd(doc + off) - 1;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != ReverseOrdFieldSource.class) {
            return false;
        }
        ReverseOrdFieldSource other = (ReverseOrdFieldSource)o;
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

