/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrException;

public class VectorDistanceFunction
extends ValueSource {
    protected MultiValueSource source1;
    protected MultiValueSource source2;
    protected float power;
    protected float oneOverPower;

    public VectorDistanceFunction(float power, MultiValueSource source1, MultiValueSource source2) {
        if (source1.dimension() != source2.dimension()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources");
        }
        this.power = power;
        this.oneOverPower = 1.0f / power;
        this.source1 = source1;
        this.source2 = source2;
    }

    protected String name() {
        return "dist";
    }

    protected double distance(int doc, FunctionValues dv1, FunctionValues dv2) {
        double[] vals1 = new double[this.source1.dimension()];
        double[] vals2 = new double[this.source1.dimension()];
        dv1.doubleVal(doc, vals1);
        dv2.doubleVal(doc, vals2);
        return VectorDistanceFunction.vectorDistance(vals1, vals2, this.power, this.oneOverPower);
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power) {
        double oneOverPower = power == 0.0 || power == 1.0 || power == 2.0 ? Double.NaN : 1.0 / power;
        return VectorDistanceFunction.vectorDistance(vec1, vec2, power, oneOverPower);
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power, double oneOverPower) {
        double result = 0.0;
        if (power == 0.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += vec1[i] - vec2[i] == 0.0 ? 0.0 : 1.0;
            }
        } else if (power == 1.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += Math.abs(vec1[i] - vec2[i]);
            }
        } else if (power == 2.0) {
            result = Math.sqrt(VectorDistanceFunction.distSquaredCartesian(vec1, vec2));
        } else if (power == 2.147483647E9 || Double.isInfinite(power)) {
            for (int i = 0; i < vec1.length; ++i) {
                result = Math.max(result, Math.max(vec1[i], vec2[i]));
            }
        } else {
            for (int i = 0; i < vec1.length; ++i) {
                result += Math.pow(vec1[i] - vec2[i], power);
            }
            result = Math.pow(result, oneOverPower);
        }
        return result;
    }

    public static double distSquaredCartesian(double[] vec1, double[] vec2) {
        double result = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            double v = vec1[i] - vec2[i];
            result += v * v;
        }
        return result;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals1 = this.source1.getValues(context, readerContext);
        final FunctionValues vals2 = this.source2.getValues(context, readerContext);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                return VectorDistanceFunction.this.distance(doc, vals1, vals2);
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(VectorDistanceFunction.this.name()).append('(').append(VectorDistanceFunction.this.power).append(',');
                boolean firstTime = true;
                sb.append(vals1.toString(doc)).append(',');
                sb.append(vals2.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.source1.createWeight(context, searcher);
        this.source2.createWeight(context, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorDistanceFunction)) {
            return false;
        }
        VectorDistanceFunction that = (VectorDistanceFunction)o;
        if (Float.compare(that.power, this.power) != 0) {
            return false;
        }
        if (!this.source1.equals(that.source1)) {
            return false;
        }
        return this.source2.equals(that.source2);
    }

    @Override
    public int hashCode() {
        int result = this.source1.hashCode();
        result = 31 * result + this.source2.hashCode();
        result = 31 * result + Float.floatToRawIntBits(this.power);
        return result;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(').append(this.power).append(',');
        sb.append(this.source1).append(',');
        sb.append(this.source2);
        sb.append(')');
        return sb.toString();
    }
}

