/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
extends IndexWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    public static final String COMMIT_TIME_MSEC_KEY = "commitTimeMSec";
    private final Object CLOSE_LOCK = new Object();
    String name;
    private DirectoryFactory directoryFactory;
    private InfoStream infoStream;
    private Directory directory;
    private volatile boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrIndexWriter create(SolrCore core, String name, String path, DirectoryFactory directoryFactory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy, Codec codec) throws IOException {
        SolrIndexWriter w = null;
        Directory d = directoryFactory.get(path, DirectoryFactory.DirContext.DEFAULT, config.lockType);
        try {
            w = new SolrIndexWriter(core, name, path, d, create, schema, config, delPolicy, codec);
            w.setDirectoryFactory(directoryFactory);
            SolrIndexWriter solrIndexWriter = w;
            return solrIndexWriter;
        }
        finally {
            if (null == w && null != d) {
                directoryFactory.doneWithDirectory(d);
                directoryFactory.release(d);
            }
        }
    }

    private SolrIndexWriter(SolrCore core, String name, String path, Directory directory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy, Codec codec) throws IOException {
        super(directory, config.toIndexWriterConfig(core).setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(delPolicy).setCodec(codec));
        log.debug("Opened Writer " + name);
        this.name = name;
        this.infoStream = this.getConfig().getInfoStream();
        this.directory = directory;
        numOpens.incrementAndGet();
    }

    private void setDirectoryFactory(DirectoryFactory factory) {
        this.directoryFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.debug("Closing Writer " + this.name);
        try {
            super.close();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            log.error("Error closing IndexWriter", t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        log.debug("Rollback Writer " + this.name);
        try {
            super.rollback();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            log.error("Exception rolling back IndexWriter", t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws IOException {
        boolean doClose = false;
        Object object = this.CLOSE_LOCK;
        synchronized (object) {
            if (!this.isClosed) {
                doClose = true;
                this.isClosed = true;
            }
        }
        if (doClose) {
            if (this.infoStream != null) {
                IOUtils.closeQuietly(this.infoStream);
            }
            numCloses.incrementAndGet();
            this.directoryFactory.release(this.directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                assert (false) : "SolrIndexWriter was not closed prior to finalize()";
                log.error("SolrIndexWriter was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

