/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.util.Args;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService updateExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("updateExecutor"));
    private ExecutorService recoveryExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("recoveryExecutor"));
    private PoolingClientConnectionManager clientConnectionManager;
    private final CloseableHttpClient client;
    private final UpdateShardHandlerConfig cfg;
    private IdleConnectionsEvictor idleConnectionsEvictor;

    @Deprecated
    public UpdateShardHandler(NodeConfig cfg) {
        this(cfg.getUpdateShardHandlerConfig());
    }

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        this.cfg = cfg;
        this.clientConnectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
        if (cfg != null) {
            this.clientConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.clientConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        }
        ModifiableSolrParams clientParams = this.getClientParams();
        log.info("Creating UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        this.client = HttpClientUtil.createClient(clientParams, this.clientConnectionManager);
        if (cfg != null) {
            this.idleConnectionsEvictor = new IdleConnectionsEvictor(this.clientConnectionManager, cfg.getUpdateConnectionsEvictorSleepDelay(), TimeUnit.MILLISECONDS, cfg.getMaxUpdateConnectionIdleTime(), TimeUnit.MILLISECONDS);
            this.idleConnectionsEvictor.start();
        }
    }

    protected ModifiableSolrParams getClientParams() {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (this.cfg != null) {
            clientParams.set("socketTimeout", this.cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", this.cfg.getDistributedConnectionTimeout());
        }
        clientParams.set("retry", true);
        return clientParams;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void reconfigureHttpClient(HttpClientConfigurer configurer) {
        log.info("Reconfiguring the default client with: " + configurer);
        configurer.configure((DefaultHttpClient)this.client, this.getClientParams());
    }

    public ClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    public ExecutorService getRecoveryExecutor() {
        return this.recoveryExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ExecutorUtil.shutdownWithInterruptAndAwaitTermination(this.updateExecutor);
            ExecutorUtil.shutdownAndAwaitTermination(this.recoveryExecutor);
            if (this.idleConnectionsEvictor != null) {
                this.idleConnectionsEvictor.shutdown();
            }
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        finally {
            IOUtils.closeQuietly(this.client);
            this.clientConnectionManager.shutdown();
        }
    }

    public static final class IdleConnectionsEvictor {
        private final ClientConnectionManager connectionManager;
        private final ThreadFactory threadFactory;
        private final Thread thread;
        private final long sleepTimeMs;
        private final long maxIdleTimeMs;
        private volatile Exception exception;

        public IdleConnectionsEvictor(final ClientConnectionManager connectionManager, ThreadFactory threadFactory, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            this.connectionManager = Args.notNull(connectionManager, "Connection manager");
            this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
            this.sleepTimeMs = sleepTimeUnit != null ? sleepTimeUnit.toMillis(sleepTime) : sleepTime;
            this.maxIdleTimeMs = maxIdleTimeUnit != null ? maxIdleTimeUnit.toMillis(maxIdleTime) : maxIdleTime;
            this.thread = this.threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(IdleConnectionsEvictor.this.sleepTimeMs);
                            connectionManager.closeExpiredConnections();
                            if (IdleConnectionsEvictor.this.maxIdleTimeMs <= 0L) continue;
                            connectionManager.closeIdleConnections(IdleConnectionsEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (Exception ex) {
                        IdleConnectionsEvictor.this.exception = ex;
                    }
                }
            });
        }

        public IdleConnectionsEvictor(ClientConnectionManager connectionManager, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            this(connectionManager, null, sleepTime, sleepTimeUnit, maxIdleTime, maxIdleTimeUnit);
        }

        public void start() {
            this.thread.start();
        }

        public void shutdown() {
            this.thread.interrupt();
        }

        public boolean isRunning() {
            return this.thread.isAlive();
        }

        public void awaitTermination(long time, TimeUnit tunit) throws InterruptedException {
            this.thread.join((tunit != null ? tunit : TimeUnit.MILLISECONDS).toMillis(time));
        }

        static class DefaultThreadFactory
        implements ThreadFactory {
            DefaultThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "solr-idle-connections-evictor");
                t.setDaemon(true);
                return t;
            }
        }
    }
}

