/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Reader;
import org.noggit.JSONParser;

public class RecordingJSONParser
extends JSONParser {
    static ThreadLocal<char[]> buf = new ThreadLocal();
    private final char[] bufCopy;
    private long globalPosition = 0L;
    private StringBuilder sb = new StringBuilder();
    private boolean objectStarted = false;
    public long lastMarkedPosition = 0L;

    public RecordingJSONParser(Reader in) {
        super(in, RecordingJSONParser.getChars());
        this.bufCopy = buf.get();
        buf.remove();
    }

    static char[] getChars() {
        buf.set(new char[8192]);
        return buf.get();
    }

    private void recordChar(int aChar) {
        if (this.objectStarted) {
            this.sb.append((char)aChar);
        } else if (aChar == 123) {
            this.sb.append((char)aChar);
            this.objectStarted = true;
        }
    }

    public void resetBuf() {
        this.sb = new StringBuilder();
        this.objectStarted = false;
    }

    @Override
    public int nextEvent() throws IOException {
        this.captureMissing();
        return super.nextEvent();
    }

    private void captureMissing() {
        long currPosition = this.getPosition() - this.globalPosition;
        if (currPosition < 0L) {
            System.out.println("ERROR");
        }
        if (currPosition > this.lastMarkedPosition) {
            for (long i = this.lastMarkedPosition; i < currPosition; ++i) {
                this.recordChar(this.bufCopy[(int)i]);
            }
        }
        this.lastMarkedPosition = currPosition;
    }

    @Override
    protected void fill() throws IOException {
        this.captureMissing();
        super.fill();
        this.globalPosition = this.getPosition();
    }

    public String getBuf() {
        this.captureMissing();
        if (this.sb != null) {
            return this.sb.toString();
        }
        return null;
    }

    public JSONParser.ParseException error(String msg) {
        return this.err(msg);
    }
}

