/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;

public class ReaderRIOTCSV
implements ReaderRIOT {
    public static final String CSV_PREFIX = "http://w3c/future-csv-vocab/";
    public static final String CSV_ROW = "http://w3c/future-csv-vocab/row";
    private InputStream input = null;
    private Reader reader = null;
    private String base;
    private String filename;
    private StreamRDF sink;
    private ParserProfile profile;

    public ReaderRIOTCSV(ErrorHandler errorHandler) {
        this.profile = RiotLib.createParserProfile(errorHandler);
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        this.input = in;
        this.reader = null;
        this.base = baseURI;
        this.filename = baseURI;
        this.sink = output;
        this.parse();
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
        this.input = null;
        this.reader = reader;
        this.base = baseURI;
        this.filename = baseURI;
        this.sink = output;
        this.parse();
    }

    public void parse() {
        this.sink.start();
        CSVParser parser = this.input != null ? CSVParser.create(this.input) : CSVParser.create(this.reader);
        ArrayList<Node> predicates = new ArrayList<Node>();
        int rowNum = 0;
        for (List<String> row : parser) {
            if (rowNum == 0) {
                for (String column : row) {
                    String uri = IRIResolver.resolveString(this.filename) + "#" + ReaderRIOTCSV.toSafeLocalname(column);
                    Node predicate = this.profile.createURI(uri, rowNum, 0L);
                    predicates.add(predicate);
                }
            } else {
                Node subject = ReaderRIOTCSV.calculateSubject(rowNum, this.filename);
                Node predicateRow = this.profile.createURI(CSV_ROW, -1L, -1L);
                Node objectRow = this.profile.createTypedLiteral(rowNum + "", (RDFDatatype)XSDDatatype.XSDinteger, rowNum, 0L);
                this.sink.triple(this.profile.createTriple(subject, predicateRow, objectRow, rowNum, 0L));
                for (int col = 0; col < row.size() && col < predicates.size(); ++col) {
                    Node o;
                    Node predicate = (Node)predicates.get(col);
                    String columnValue = row.get(col).trim();
                    if ("".equals(columnValue)) continue;
                    try {
                        Double.parseDouble(columnValue);
                        o = NodeFactory.createLiteral((String)columnValue, (RDFDatatype)XSDDatatype.XSDdouble);
                    }
                    catch (Exception e2) {
                        o = NodeFactory.createLiteral((String)columnValue);
                    }
                    this.sink.triple(this.profile.createTriple(subject, predicate, o, rowNum, col));
                }
            }
            ++rowNum;
        }
        this.sink.finish();
    }

    public static String toSafeLocalname(String raw) {
        String ret = raw.trim();
        return ReaderRIOTCSV.encodeURIComponent(ret);
    }

    private static String encodeURIComponent(String s) {
        return IRILib.encodeUriComponent((String)s);
    }

    public static Node calculateSubject(int rowNum, String filename) {
        Node subject = NodeFactory.createBlankNode();
        return subject;
    }

    public static class Factory
    implements ReaderRIOTFactory {
        @Override
        public ReaderRIOT create(Lang language, ParserProfile profile) {
            return new ReaderRIOTCSV(profile.getErrorHandler());
        }
    }
}

