/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformRemoveAssignment;
import org.apache.jena.sparql.algebra.optimize.VariableUsagePusher;
import org.apache.jena.sparql.algebra.optimize.VariableUsageTracker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformEliminateAssignments
extends TransformCopy {
    private final OpVisitor before;
    private final OpVisitor after;
    private final AssignmentTracker tracker;
    private final boolean aggressive;

    public static Op eliminate(Op op) {
        return TransformEliminateAssignments.eliminate(op, false);
    }

    public static Op eliminate(Op op, boolean aggressive) {
        AssignmentTracker tracker = new AssignmentTracker();
        AssignmentPusher pusher = new AssignmentPusher(tracker);
        AssignmentPopper popper = new AssignmentPopper(tracker);
        TransformEliminateAssignments transform = new TransformEliminateAssignments(tracker, pusher, popper, aggressive);
        ExprTransformEliminateAssignments exprTransform = new ExprTransformEliminateAssignments(aggressive);
        return Transformer.transformSkipService(transform, exprTransform, op, pusher, popper);
    }

    private TransformEliminateAssignments(AssignmentTracker tracker, OpVisitor before, OpVisitor after) {
        this(tracker, before, after, false);
    }

    private TransformEliminateAssignments(AssignmentTracker tracker, OpVisitor before, OpVisitor after, boolean aggressive) {
        this.tracker = tracker;
        this.before = before;
        this.after = after;
        this.aggressive = aggressive;
    }

    protected boolean canInline(Expr e2) {
        if (e2 == null) {
            return false;
        }
        return ExprLib.isStable(e2);
    }

    protected boolean shouldInline(Expr e2) {
        if (e2 == null) {
            return false;
        }
        if (this.aggressive) {
            return true;
        }
        return e2.isConstant() || e2 instanceof NodeValue;
    }

    protected boolean isApplicable() {
        if (!this.tracker.insideProjection()) {
            return false;
        }
        return this.tracker.assignments.size() != 0;
    }

    @Override
    public Op transform(OpExt opExt) {
        return opExt.apply(this, this.before, this.after);
    }

    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        if (!this.isApplicable()) {
            return super.transform(opFilter, subOp);
        }
        HashSet<Var> vars = new HashSet<Var>();
        for (Expr expr : opFilter.getExprs().getList()) {
            ExprVars.nonOpVarsMentioned(vars, expr);
        }
        ExprList exprs = opFilter.getExprs();
        boolean modified = false;
        for (Var var : vars) {
            Expr e2 = this.getAssignExpr(var);
            if (this.tracker.getUsageCount(var) != 2 || !this.hasAssignment(var) || !this.canInline(e2)) continue;
            subOp = this.eliminateAssignment(subOp, var);
            exprs = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(var, e2), exprs);
            this.tracker.getAssignments().remove((Object)var);
            modified = true;
        }
        if (modified) {
            return OpFilter.filterBy(exprs, subOp);
        }
        return super.transform(opFilter, subOp);
    }

    private boolean hasAssignment(Var var) {
        return this.tracker.getAssignments().containsKey((Object)var);
    }

    private Expr getAssignExpr(Var var) {
        return this.tracker.getAssignments().get((Object)var);
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        if (!this.tracker.insideProjection()) {
            return super.transform(opExtend, subOp);
        }
        this.tracker.putAssignments(opExtend.getVarExprList());
        VarExprList unusedAssignments = this.processUnused(opExtend.getVarExprList());
        VarExprList newAssignments = new VarExprList();
        for (Var assignVar : opExtend.getVarExprList().getVars()) {
            if (unusedAssignments != null && unusedAssignments.contains(assignVar)) continue;
            Expr currExpr = opExtend.getVarExprList().getExpr(assignVar);
            HashSet<Var> vars = new HashSet<Var>();
            ExprVars.nonOpVarsMentioned(vars, currExpr);
            for (Var var : vars) {
                Expr e2 = this.getAssignExpr(var);
                if (this.tracker.getUsageCount(var) != 2 || !this.hasAssignment(var) || !this.canInline(e2)) continue;
                subOp = this.eliminateAssignment(subOp, var);
                currExpr = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(var, e2), currExpr);
                this.tracker.getAssignments().remove((Object)var);
                this.tracker.updateAssignments(var, e2);
                if (!newAssignments.contains(var) || !newAssignments.getExpr(var).equals(e2)) continue;
                newAssignments.getVars().remove((Object)var);
                newAssignments.getExprs().remove((Object)var);
            }
            newAssignments.add(assignVar, currExpr);
        }
        if (newAssignments.size() > 0) {
            return OpExtend.create(subOp, newAssignments);
        }
        return subOp;
    }

    private VarExprList processUnused(VarExprList assignments) {
        if (Collections.disjoint(assignments.getVars(), this.tracker.getAssignments().keySet())) {
            return null;
        }
        VarExprList singleUse = new VarExprList();
        for (Var var : assignments.getVars()) {
            if (this.tracker.getUsageCount(var) != 1) continue;
            singleUse.add(var, assignments.getExpr(var));
        }
        if (singleUse.size() == 0) {
            return null;
        }
        return singleUse;
    }

    @Override
    public Op transform(OpOrder opOrder, Op subOp) {
        if (!this.isApplicable()) {
            return super.transform(opOrder, subOp);
        }
        ArrayList<Var> vars = new ArrayList<Var>();
        for (SortCondition cond : opOrder.getConditions()) {
            ExprVars.varsMentioned(vars, cond.getExpression());
        }
        List<SortCondition> conditions = null;
        for (Var var : vars) {
            Expr e2 = this.getAssignExpr(var);
            if (this.tracker.getUsageCount(var) != 2 || !this.hasAssignment(var) || !this.canInline(e2) || !this.shouldInline(e2)) continue;
            subOp = this.eliminateAssignment(subOp, var);
            conditions = this.processConditions(opOrder.getConditions(), conditions, var);
            this.tracker.getAssignments().remove((Object)var);
        }
        if (conditions != null) {
            return new OpOrder(subOp, conditions);
        }
        return super.transform(opOrder, subOp);
    }

    private List<SortCondition> processConditions(List<SortCondition> baseConditions, List<SortCondition> processedConditions, Var var) {
        List<SortCondition> inputConditions = processedConditions != null ? processedConditions : baseConditions;
        ArrayList<SortCondition> outputConditions = new ArrayList<SortCondition>();
        for (SortCondition cond : inputConditions) {
            Expr e2 = cond.getExpression();
            e2 = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(var, this.getAssignExpr(var)), e2);
            outputConditions.add(new SortCondition(e2, cond.getDirection()));
        }
        return outputConditions;
    }

    @Override
    public Op transform(OpTopN opTop, Op subOp) {
        if (!this.isApplicable()) {
            return super.transform(opTop, subOp);
        }
        ArrayList<Var> vars = new ArrayList<Var>();
        for (SortCondition cond : opTop.getConditions()) {
            ExprVars.varsMentioned(vars, cond.getExpression());
        }
        List<SortCondition> conditions = null;
        for (Var var : vars) {
            Expr e2 = this.getAssignExpr(var);
            if (this.tracker.getUsageCount(var) != 2 || !this.hasAssignment(var) || !this.canInline(e2) || !this.shouldInline(e2)) continue;
            subOp = this.eliminateAssignment(subOp, var);
            conditions = this.processConditions(opTop.getConditions(), conditions, var);
            this.tracker.getAssignments().remove((Object)var);
        }
        if (conditions != null) {
            return new OpTopN(subOp, opTop.getLimit(), conditions);
        }
        return super.transform(opTop, subOp);
    }

    @Override
    public Op transform(OpGroup opGroup, Op subOp) {
        return super.transform(opGroup, subOp);
    }

    private Op eliminateAssignment(Op subOp, Var var) {
        return Transformer.transform(new TransformRemoveAssignment(var, this.getAssignExpr(var)), subOp);
    }

    private VarExprList processVarExprList(VarExprList exprs, ExprTransform transform) {
        VarExprList newExprs = new VarExprList();
        for (Var v : exprs.getVars()) {
            Expr e2 = exprs.getExpr(v);
            Expr e22 = ExprTransformer.transform(transform, e2);
            newExprs.add(v, e22);
        }
        return newExprs;
    }

    private List<ExprAggregator> processAggregators(List<ExprAggregator> aggs, ExprTransform transform) {
        ArrayList<ExprAggregator> newAggs = new ArrayList<ExprAggregator>();
        for (ExprAggregator agg : aggs) {
            ExprAggregator e2 = (ExprAggregator)ExprTransformer.transform(transform, agg);
            newAggs.add(e2);
        }
        return newAggs;
    }

    private static class ExprTransformEliminateAssignments
    extends ExprTransformCopy {
        private final boolean aggressive;

        public ExprTransformEliminateAssignments(boolean aggressive) {
            this.aggressive = aggressive;
        }

        @Override
        public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
            AssignmentTracker tracker = new AssignmentTracker();
            AssignmentPusher pusher = new AssignmentPusher(tracker);
            AssignmentPopper popper = new AssignmentPopper(tracker);
            TransformEliminateAssignments transform = new TransformEliminateAssignments(tracker, pusher, popper, this.aggressive);
            ExprTransformEliminateAssignments exprTransform = new ExprTransformEliminateAssignments(this.aggressive);
            Op opArg2 = Transformer.transform(transform, exprTransform, opArg, pusher, popper);
            if (opArg2 == opArg) {
                return super.transform(funcOp, args, opArg);
            }
            if (funcOp instanceof E_Exists) {
                return new E_Exists(opArg2);
            }
            if (funcOp instanceof E_NotExists) {
                return new E_NotExists(opArg2);
            }
            throw new ARQInternalErrorException("Unrecognized ExprFunctionOp: \n" + funcOp);
        }
    }

    private static class AssignmentPopper
    extends OpVisitorBase {
        private AssignmentTracker tracker;

        public AssignmentPopper(AssignmentTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        public void visit(OpProject opProject) {
            Iterator<Var> vars = this.tracker.getAssignments().keySet().iterator();
            while (vars.hasNext()) {
                Var var = vars.next();
                if (opProject.getVars().contains((Object)var)) continue;
                vars.remove();
            }
            this.tracker.pop();
            this.tracker.decrementDepth();
        }

        @Override
        public void visit(OpUnion opUnion) {
            this.unsafe();
        }

        @Override
        public void visit(OpJoin opJoin) {
            this.unsafe();
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            this.unsafe();
        }

        @Override
        public void visit(OpMinus opMinus) {
            this.unsafe();
        }

        @Override
        public void visit(OpDistinct opDistinct) {
            this.unsafe();
        }

        @Override
        public void visit(OpReduced opReduced) {
            this.unsafe();
        }

        private void unsafe() {
            this.tracker.getAssignments().clear();
        }
    }

    private static class AssignmentPusher
    extends VariableUsagePusher {
        private AssignmentTracker assignmentTracker;

        public AssignmentPusher(AssignmentTracker tracker) {
            super(tracker);
            this.assignmentTracker = tracker;
        }

        @Override
        public void visit(OpProject opProject) {
            super.visit(opProject);
            this.assignmentTracker.incrementDepth();
        }
    }

    private static class AssignmentTracker
    extends VariableUsageTracker {
        private Map<Var, Expr> assignments = new HashMap<Var, Expr>();
        private int depth = 0;

        private AssignmentTracker() {
        }

        public Map<Var, Expr> getAssignments() {
            return this.assignments;
        }

        public void putAssignments(VarExprList assignments) {
            for (Var var : assignments.getVars()) {
                int i = this.getUsageCount(var);
                if (i <= 2) {
                    this.assignments.put(var, assignments.getExpr(var));
                    continue;
                }
                this.assignments.remove((Object)var);
            }
        }

        @Override
        public void increment(String var) {
            super.increment(var);
            int i = this.getUsageCount(var);
            if (i > 2) {
                this.assignments.remove(var);
            }
        }

        public void updateAssignments(Var v, Expr e2) {
            ExprTransformSubstitute transform = new ExprTransformSubstitute(v, e2);
            for (Var assignVar : this.assignments.keySet()) {
                Expr assignExpr = this.assignments.get((Object)assignVar);
                assignExpr = ExprTransformer.transform((ExprTransform)transform, assignExpr);
                this.assignments.put(assignVar, assignExpr);
            }
        }

        public void incrementDepth() {
            ++this.depth;
        }

        public void decrementDepth() {
            --this.depth;
            if (this.depth == 0) {
                this.assignments.clear();
            }
        }

        public boolean insideProjection() {
            return this.depth > 0;
        }
    }
}

