/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphUnionRead
extends GraphBase {
    private final DatasetGraph dataset;
    private final Collection<Node> graphs;

    public GraphUnionRead(DatasetGraph dsg) {
        this(dsg, null);
    }

    public GraphUnionRead(DatasetGraph dsg, Collection<Node> graphs) {
        this.dataset = dsg;
        this.graphs = graphs;
    }

    protected PrefixMapping createPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        this.forEachGraph(arg_0 -> GraphUnionRead.lambda$createPrefixMapping$159((PrefixMapping)pmap, arg_0));
        return pmap;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        IteratorConcat iter = new IteratorConcat();
        this.forEachGraph(g -> iter.add((Iterator)g.find(m)));
        return WrappedIterator.create((Iterator)Iter.distinct((Iterator)iter));
    }

    private void forEachGraph(Consumer<Graph> action) {
        if (this.graphs == null) {
            this.dataset.listGraphNodes().forEachRemaining(gn -> action.accept(this.dataset.getGraph((Node)gn)));
            return;
        }
        this.graphs.stream().filter(gn -> this.dataset.containsGraph((Node)gn)).map(gn -> Quad.isDefaultGraph(gn) ? this.dataset.getDefaultGraph() : this.dataset.getGraph((Node)gn)).forEach(action);
    }

    public void performAdd(Triple t) {
        throw new AddDeniedException("GraphUnionRead::performAdd - read-only graph");
    }

    public void performDelete(Triple t) {
        throw new DeleteDeniedException("GraphUnionRead::performDelete - Read-only graph");
    }

    private static /* synthetic */ void lambda$createPrefixMapping$159(PrefixMapping prefixMapping, Graph g) {
        PrefixMapping pmapNamedGraph = g.getPrefixMapping();
        prefixMapping.setNsPrefixes(pmapNamedGraph);
    }
}

