/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModAlgebra;
import arq.cmdline.ModDataset;
import arq.cmdline.ModDatasetGeneralAssembler;
import arq.cmdline.ModEngine;
import arq.cmdline.ModResultsOut;
import arq.cmdline.ModTime;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.TerminationException;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.PlanOp;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.util.QueryExecUtils;

public class sse_query
extends CmdARQ {
    protected final ArgDecl printDecl = new ArgDecl(true, "print");
    ModAlgebra modAlgebra = new ModAlgebra();
    ModDataset modDataset = new ModDatasetGeneralAssembler();
    ModResultsOut modResults = new ModResultsOut();
    ModTime modTime = new ModTime();
    ModEngine modEngine = new ModEngine();
    boolean printOp = false;
    boolean printPlan = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String ... argv) {
        new sse_query(argv).mainRun();
    }

    public sse_query(String[] argv) {
        super(argv);
        super.add(this.printDecl, "--print=op/plan", "Print details");
        super.addModule(this.modAlgebra);
        super.addModule(this.modResults);
        super.addModule(this.modDataset);
        super.addModule(this.modTime);
        super.addModule(this.modEngine);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        for (String arg : this.getValues(this.printDecl)) {
            if (arg.equalsIgnoreCase("op") || arg.equalsIgnoreCase("alg") || arg.equalsIgnoreCase("algebra")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad");
        }
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --data=<file> --query=<query>";
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    @Override
    protected void exec() {
        Op op = this.modAlgebra.getOp();
        if (op == null) {
            System.err.println("No query expression to execute");
            throw new TerminationException(9);
        }
        Dataset dataset = this.modDataset.getDataset();
        if (dataset == null) {
            dataset = DatasetFactory.createGeneral();
        }
        this.modTime.startTimer();
        DatasetGraph dsg = dataset.asDatasetGraph();
        if (this.printOp || this.printPlan) {
            if (this.printOp) {
                this.divider();
                IndentedWriter out = new IndentedWriter(System.out, true);
                op.output(out);
                out.flush();
            }
            if (this.printPlan) {
                QueryIterator qIter = Algebra.exec(op, dsg);
                PlanOp plan = new PlanOp(op, null, qIter);
                this.divider();
                IndentedWriter out = new IndentedWriter(System.out, false);
                plan.output(out);
                out.flush();
            }
        }
        QueryExecUtils.execute(op, dsg, this.modResults.getResultsFormat());
        long time = this.modTime.endTimer();
        if (this.modTime.timingEnabled()) {
            System.out.println("Time: " + this.modTime.timeStr(time));
        }
    }
}

