/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.exceptions.CannotConstructException;
import org.apache.jena.assembler.exceptions.CannotLoadClassException;
import org.apache.jena.assembler.exceptions.NotUniqueException;
import org.apache.jena.assembler.exceptions.PropertyRequiredException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.JenaException;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.vocabulary.RDF;

public abstract class AssemblerBase
implements Assembler {
    @Override
    public final Object open(Resource root2) {
        return this.open(this, root2);
    }

    @Override
    public final Object open(Assembler a, Resource root2) {
        return this.open(a, root2, Mode.DEFAULT);
    }

    @Override
    public abstract Object open(Assembler var1, Resource var2, Mode var3);

    protected static Resource getUniqueResource(Resource root2, Property property) {
        return (Resource)AssemblerBase.getUnique(root2, property);
    }

    protected static Literal getUniqueLiteral(Resource root2, Property property) {
        return (Literal)AssemblerBase.getUnique(root2, property);
    }

    protected static Statement getUniqueStatement(Resource root2, Property property) {
        List statements = root2.listProperties(property).toList();
        if (statements.size() == 0) {
            return null;
        }
        if (statements.size() == 1) {
            return (Statement)statements.get(0);
        }
        throw new NotUniqueException(root2, property);
    }

    protected static RDFNode getUnique(Resource root2, Property property) {
        List<RDFNode> nodes = root2.listProperties(property).mapWith(s -> s.getObject()).toList();
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        throw new NotUniqueException(root2, property);
    }

    protected void checkType(Resource root2, Resource type) {
        if (!root2.hasProperty(RDF.type, type)) {
            throw new CannotConstructException(this.getClass(), root2, type);
        }
    }

    @Override
    public Model openModel(Resource root2, Mode mode) {
        return (Model)this.open(this, root2, mode);
    }

    @Override
    public Model openModel(Resource root2) {
        return this.openModel(root2, Mode.DEFAULT);
    }

    public static Resource getRequiredResource(Resource root2, Property p) {
        Resource R = AssemblerBase.getUniqueResource(root2, p);
        if (R == null) {
            throw new PropertyRequiredException(root2, p);
        }
        return R;
    }

    protected Literal getRequiredLiteral(Resource root2, Property p) {
        Literal L2 = AssemblerBase.getUniqueLiteral(root2, p);
        if (L2 == null) {
            throw new PropertyRequiredException(root2, p);
        }
        return L2;
    }

    protected static Resource getResource(Statement s) {
        return AssemblerHelp.getResource(s);
    }

    protected static String getString(Statement s) {
        return AssemblerHelp.getString(s);
    }

    protected static String getUniqueString(Resource root2, Property property) {
        Statement s = AssemblerBase.getUniqueStatement(root2, property);
        return s == null ? null : AssemblerHelp.getString(s);
    }

    protected static Class<?> loadClass(Resource root2, String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new CannotLoadClassException(root2, className, e2);
        }
    }

    public static String getOptionalClassName(Resource root2, Property classProperty) {
        RDFNode classNode = AssemblerBase.getUnique(root2, classProperty);
        return classNode == null ? null : (classNode.isLiteral() ? classNode.asNode().getLiteralLexicalForm() : (classNode.isResource() ? AssemblerBase.mustBeJava(classNode.asNode().getURI()) : null));
    }

    private static String mustBeJava(String uri) {
        if (uri.startsWith("java:")) {
            return uri.substring(5);
        }
        throw new JenaException("class name URI must start with 'java:': " + uri);
    }

    static {
        JenaSystem.init();
    }
}

