/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.block;

import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrLogger
implements BlockMgr {
    private final BlockMgr blockMgr;
    protected final Logger log;
    protected final boolean logAllOperations;
    private final String label;

    public BlockMgrLogger(BlockMgr blockMgr, boolean logAllOperations) {
        this(null, blockMgr.getLabel(), blockMgr, logAllOperations);
    }

    public BlockMgrLogger(String label, BlockMgr blockMgr, boolean logAllOperations) {
        this(null, label, blockMgr, logAllOperations);
    }

    public BlockMgrLogger(Logger log2, String label, BlockMgr blockMgr, boolean logAllOperations) {
        this.blockMgr = blockMgr;
        if (log2 == null) {
            log2 = LoggerFactory.getLogger(BlockMgr.class);
        }
        this.log = log2;
        this.logAllOperations = logAllOperations;
        if (label == null) {
            label = blockMgr.getLabel();
        }
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Block allocate(int blockSize) {
        Block x = this.blockMgr.allocate(blockSize);
        this.info("Allocate(" + x.getId() + ")");
        return x;
    }

    @Override
    public boolean isEmpty() {
        this.info("isEmpty()");
        return this.blockMgr.isEmpty();
    }

    @Override
    public long allocLimit() {
        this.info("limit()");
        return this.blockMgr.allocLimit();
    }

    @Override
    public void resetAlloc(long boundary) {
        this.info("resetAlloc(" + boundary + ")");
        this.blockMgr.resetAlloc(boundary);
    }

    @Override
    public Block getRead(long id) {
        this.info("getRead(" + id + ")");
        return this.blockMgr.getRead(id);
    }

    @Override
    public Block getWrite(long id) {
        this.info("getWrite(" + id + ")");
        return this.blockMgr.getWrite(id);
    }

    @Override
    public Block promote(Block block) {
        this.info("promote(" + block.getId() + ")");
        return this.blockMgr.promote(block);
    }

    @Override
    public void release(Block block) {
        this.info("release(" + block.getId() + ")");
        this.blockMgr.release(block);
    }

    @Override
    public void write(Block block) {
        this.info("write(" + block.getId() + ")");
        this.blockMgr.write(block);
    }

    @Override
    public void overwrite(Block block) {
        this.info("overwrite(" + block.getId() + ")");
        this.blockMgr.overwrite(block);
    }

    @Override
    public void free(Block block) {
        this.info("freeBlock(" + block.getId() + ")");
        this.blockMgr.free(block);
    }

    @Override
    public boolean valid(int id) {
        this.info("valid(" + id + ")");
        return this.blockMgr.valid(id);
    }

    @Override
    public void close() {
        this.info("close");
        this.blockMgr.close();
    }

    @Override
    public boolean isClosed() {
        this.info("isClosed");
        return this.blockMgr.isClosed();
    }

    @Override
    public void sync() {
        this.info("sync");
        this.blockMgr.sync();
    }

    @Override
    public void syncForce() {
        this.info("syncForce");
        this.blockMgr.syncForce();
    }

    @Override
    public void beginRead() {
        this.info("> start read");
        this.blockMgr.beginRead();
    }

    @Override
    public void endRead() {
        this.info("< finish read");
        this.blockMgr.endRead();
    }

    @Override
    public void beginUpdate() {
        this.info("> start update");
        this.blockMgr.beginUpdate();
    }

    @Override
    public void endUpdate() {
        this.info("< finish update");
        this.blockMgr.endUpdate();
    }

    private void info(String string) {
        if (this.label != null) {
            string = this.label + ": " + string;
        }
        this.log.info(string);
    }
}

