/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.build.DatasetDescriptionRegistry;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDF;

public class FusekiBuilder {
    public static DataAccessPoint buildDataAccessPoint(Resource svc, DatasetDescriptionRegistry dsDescMap) {
        RDFNode n = FusekiLib.getOne(svc, "fu:name");
        if (!n.isLiteral()) {
            throw new FusekiConfigException("Not a literal for access point name: " + FmtUtils.stringForRDFNode(n));
        }
        Literal object = n.asLiteral();
        if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
            Fuseki.configLog.error(String.format("Service name '%s' is not a string", FmtUtils.stringForRDFNode(object)));
        }
        String name = object.getLexicalForm();
        name = DataAccessPoint.canonical(name);
        DataService dataService = FusekiBuilder.buildDataServiceCustom(svc, dsDescMap);
        DataAccessPoint dataAccess = new DataAccessPoint(name, dataService);
        return dataAccess;
    }

    private static DataService buildDataServiceCustom(Resource svc, DatasetDescriptionRegistry dsDescMap) {
        Resource datasetDesc = (Resource)FusekiBuilder.getOne(svc, "fu:dataset");
        Dataset ds = FusekiBuilder.getDataset(datasetDesc, dsDescMap);
        DataService dataService = new DataService(ds.asDatasetGraph());
        FusekiBuilder.addServiceEP(dataService, Operation.Query, svc, FusekiVocab.pServiceQueryEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Update, svc, FusekiVocab.pServiceUpdateEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Upload, svc, FusekiVocab.pServiceUploadEP);
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, svc, FusekiVocab.pServiceReadGraphStoreEP);
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_RW, svc, FusekiVocab.pServiceReadWriteGraphStoreEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Quads_R, svc, FusekiVocab.pServiceReadQuadsEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Quads_RW, svc, FusekiVocab.pServiceReadWriteQuadsEP);
        if (!dataService.getEndpoints(Operation.GSP_RW).isEmpty() || !dataService.getEndpoints(Operation.Quads_RW).isEmpty()) {
            dataService.addEndpoint(Operation.DatasetRequest_RW, "");
        } else if (!dataService.getEndpoints(Operation.GSP_R).isEmpty() || !dataService.getEndpoints(Operation.Quads_R).isEmpty()) {
            dataService.addEndpoint(Operation.DatasetRequest_R, "");
        }
        return dataService;
    }

    static Dataset getDataset(Resource datasetDesc, DatasetDescriptionRegistry dsDescMap) {
        Dataset ds = dsDescMap.get(datasetDesc);
        if (ds == null) {
            if (!datasetDesc.hasProperty(RDF.type)) {
                throw new FusekiConfigException("No rdf:type for dataset " + FusekiLib.nodeLabel(datasetDesc));
            }
            ds = (Dataset)Assembler.general.open(datasetDesc);
        }
        dsDescMap.register(datasetDesc, ds);
        return ds;
    }

    public static DataService buildDataServiceStd(DatasetGraph dsg, boolean allowUpdate) {
        DataService dataService = new DataService(dsg);
        FusekiBuilder.populateStdServices(dataService, allowUpdate);
        return dataService;
    }

    public static void populateStdServices(DataService dataService, boolean allowUpdate) {
        FusekiBuilder.addServiceEP(dataService, Operation.Query, "query");
        FusekiBuilder.addServiceEP(dataService, Operation.Query, "sparql");
        if (!allowUpdate) {
            FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, "data");
            FusekiBuilder.addServiceEP(dataService, Operation.DatasetRequest_R, "");
            return;
        }
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_RW, "data");
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, "get");
        FusekiBuilder.addServiceEP(dataService, Operation.Update, "update");
        FusekiBuilder.addServiceEP(dataService, Operation.Upload, "upload");
        FusekiBuilder.addServiceEP(dataService, Operation.DatasetRequest_RW, "");
    }

    public static void addServiceEP(DataService dataService, Operation operation, String endpointName) {
        dataService.addEndpoint(operation, endpointName);
    }

    public static RDFNode getOne(Resource svc, String property) {
        String ln2 = property.substring(property.indexOf(58) + 1);
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No " + ln2 + " for service " + FusekiLib.nodeLabel(svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple " + ln2 + " for service " + FusekiLib.nodeLabel(svc));
        }
        return x;
    }

    private static void addServiceEP(DataService dataService, Operation operation, Resource svc, Property property) {
        String p = "<" + property.getURI() + ">";
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + p + " ?ep}", svc.getModel(), "svc", (RDFNode)svc);
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String epName = soln.getLiteral("ep").getLexicalForm();
            FusekiBuilder.addServiceEP(dataService, operation, epName);
        }
    }
}

