/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.assembler.JA;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.build.DatasetDescriptionRegistry;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DatasetStatus;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;

public class FusekiConfig {
    private static Logger log;

    public static void processServerConfig(Model model) {
        List<Resource> servers = GraphUtils.listResourcesByType(model, FusekiVocab.tServer);
        if (servers.size() == 0) {
            return;
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Resource server = servers.get(0);
        FusekiConfig.processServer(server);
    }

    private static void processServer(Resource server) {
        AssemblerUtils.setContext(server, Fuseki.getContext());
        StmtIterator sIter = server.listProperties(JA.loadClass);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            RDFNode rn = s.getObject();
            String className = null;
            if (rn instanceof Resource) {
                String uri = ((Resource)rn).getURI();
                if (uri == null) {
                    log.warn("Blank node for class to load");
                    continue;
                }
                String javaScheme = "java:";
                if (!uri.startsWith(javaScheme)) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            }
            if (rn instanceof Literal) {
                className = ((Literal)rn).getLexicalForm();
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    public static List<DataAccessPoint> servicesAndDatasets(Model model) {
        DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
        ResultSet rs = FusekiLib.query("SELECT * { ?s fu:services [ list:member ?service ] }", model);
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>();
        if (!rs.hasNext()) {
            rs = FusekiLib.query("SELECT ?service { ?service a fu:Service }", model);
        }
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Resource svc = soln.getResource("service");
            DataAccessPoint acc = FusekiBuilder.buildDataAccessPoint(svc, dsDescMap);
            accessPoints.add(acc);
        }
        return accessPoints;
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e2) {
            throw new FusekiConfigException(e2);
        }
    }

    private static Model readAssemblerFile(String filename) {
        return AssemblerUtils.readAssemblerFile(filename);
    }

    public static List<DataAccessPoint> readConfigurationDirectory(String dir) {
        Path pDir = Paths.get(dir, new String[0]).normalize();
        File dirFile = pDir.toFile();
        if (!dirFile.exists()) {
            log.warn("Not found: directory for assembler files for services: '" + dir + "'");
            return Collections.emptyList();
        }
        if (!dirFile.isDirectory()) {
            log.warn("Not a directory: '" + dir + "'");
            return Collections.emptyList();
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            File f = entry.toFile();
            Lang lang = RDFLanguages.filenameToLang(f.getName());
            return !f.isHidden() && f.isFile() && lang != null && RDFParserRegistry.isRegistered(lang);
        };
        ArrayList<DataAccessPoint> dataServiceRef = new ArrayList<DataAccessPoint>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pDir, filter);){
            for (Path p : stream) {
                DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
                String fn = IRILib.filenameToIRI(p.toString());
                log.info("Load configuration: " + fn);
                Model m = FusekiConfig.readAssemblerFile(fn);
                FusekiConfig.readConfiguration(m, dsDescMap, dataServiceRef);
            }
        }
        catch (IOException ex) {
            log.warn("IOException:" + ex.getMessage(), ex);
        }
        return dataServiceRef;
    }

    private static void readConfiguration(Model m, DatasetDescriptionRegistry dsDescMap, List<DataAccessPoint> dataServiceRef) {
        List<Resource> services = GraphUtils.listResourcesByType(m, FusekiVocab.fusekiService);
        if (services.size() == 0) {
            log.error("No services found");
            throw new FusekiConfigException();
        }
        for (Resource service : services) {
            DataAccessPoint acc = FusekiBuilder.buildDataAccessPoint(service, dsDescMap);
            dataServiceRef.add(acc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataAccessPoint> readSystemDatabase(Dataset ds) {
        DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
        String qs = StrUtils.strjoinNL(SystemState.PREFIXES, "SELECT * {", "  GRAPH ?g {", "     ?s fu:name ?name ;", "        fu:status ?status .", "  }", "}");
        ArrayList<DataAccessPoint> refs = new ArrayList<DataAccessPoint>();
        ds.begin(ReadWrite.WRITE);
        try {
            ResultSet rs = FusekiLib.query(qs, ds);
            while (rs.hasNext()) {
                QuerySolution row = rs.next();
                Resource s = row.getResource("s");
                Resource g = row.getResource("g");
                Resource rStatus = row.getResource("status");
                DatasetStatus status = DatasetStatus.status(rStatus);
                Model m = ds.getNamedModel(g.getURI());
                Resource svc = m.wrapAsResource(s.asNode());
                DataAccessPoint ref = FusekiBuilder.buildDataAccessPoint(svc, dsDescMap);
                refs.add(ref);
            }
            ds.commit();
            ArrayList<DataAccessPoint> arrayList = refs;
            return arrayList;
        }
        finally {
            ds.end();
        }
    }

    static {
        Fuseki.init();
        log = Fuseki.configLog;
    }
}

