/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.TerminationException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLogging;
import org.apache.jena.fuseki.jetty.JettyFuseki;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiInitialConfig;
import org.apache.jena.fuseki.server.FusekiServerListener;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb.TDB;
import org.slf4j.Logger;

public class FusekiCmd {
    public static void main(String ... argv) {
        FusekiCmdInner.innerMain(argv);
    }

    public static void runFuseki(FusekiInitialConfig serverConfig, JettyServerConfig jettyConfig) {
        FusekiServerListener.initialSetup = serverConfig;
        JettyFuseki.initializeServer(jettyConfig);
        JettyFuseki.instance.start();
        JettyFuseki.instance.join();
    }

    static {
        FusekiEnv.mode = FusekiEnv.INIT.STANDALONE;
        FusekiLogging.setLogging();
    }

    static class FusekiCmdInner
    extends CmdARQ {
        private static ArgDecl argMgt = new ArgDecl(false, "mgt");
        private static ArgDecl argMgtPort = new ArgDecl(true, "mgtPort", "mgtport");
        private static ArgDecl argHome = new ArgDecl(true, "home");
        private static ArgDecl argPages = new ArgDecl(true, "pages");
        private static ArgDecl argMem = new ArgDecl(false, "mem");
        private static ArgDecl argUpdate = new ArgDecl(false, "update", "allowUpdate");
        private static ArgDecl argFile = new ArgDecl(true, "file");
        private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB", "tdbmem");
        private static ArgDecl argTDB = new ArgDecl(true, "loc", "location", "tdb");
        private static ArgDecl argPort = new ArgDecl(true, "port");
        private static ArgDecl argLocalhost = new ArgDecl(false, "localhost", "local");
        private static ArgDecl argTimeout = new ArgDecl(true, "timeout");
        private static ArgDecl argFusekiConfig = new ArgDecl(true, "config", "conf");
        private static ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config");
        private static ArgDecl argGZip = new ArgDecl(true, "gzip");
        private static ArgDecl argBasicAuth = new ArgDecl(true, "basic-auth");
        private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
        private JettyServerConfig jettyServerConfig = new JettyServerConfig();
        private final FusekiInitialConfig cmdLineConfig;
        static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

        public static void innerMain(String ... argv) {
            JenaSystem.init();
            Fuseki.init();
            new FusekiCmdInner(argv).mainRun();
        }

        public FusekiCmdInner(String ... argv) {
            super(argv);
            this.jettyServerConfig.port = 3030;
            this.jettyServerConfig.contextPath = "/";
            this.jettyServerConfig.jettyConfigFile = null;
            this.jettyServerConfig.enableCompression = true;
            this.jettyServerConfig.verboseLogging = false;
            this.cmdLineConfig = new FusekiInitialConfig();
            this.getUsage().startCategory("Fuseki");
            this.addModule(modDataset);
            this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
            this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
            this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
            this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
            this.add(argPort, "--port", "Listen on this port number");
            this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
            this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
            this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
            this.add(argFusekiConfig, "--config=", "Use a configuration file to determine the services");
            this.add(argJettyConfig, "--jetty-config=FILE", "Set up the server (not services) with a Jetty XML file");
            this.add(argBasicAuth);
            this.add(argPages);
            this.add(argMgt);
            this.add(argMgtPort);
            this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
            this.modVersion.addClass(TDB.class);
            this.modVersion.addClass(Fuseki.class);
        }

        @Override
        protected String getSummary() {
            return this.getCommandName() + " " + argUsage;
        }

        @Override
        protected void processModulesAndArgs() {
            Object dir;
            boolean cmdlineConfigPresent;
            if (super.isVerbose() || super.isDebug()) {
                this.jettyServerConfig.verboseLogging = true;
            }
            this.cmdLineConfig.quiet = super.isQuiet();
            this.cmdLineConfig.verbose = super.isVerbose();
            FusekiEnv.resetEnvironment();
            Logger log2 = Fuseki.serverLog;
            if (this.contains(argFusekiConfig)) {
                this.cmdLineConfig.fusekiCmdLineConfigFile = this.getValue(argFusekiConfig);
                this.cmdLineConfig.datasetDescription = "Configuration: " + this.cmdLineConfig.fusekiCmdLineConfigFile;
            }
            ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
            int x = 0;
            if (this.contains(argMem)) {
                ++x;
            }
            if (this.contains(argFile)) {
                ++x;
            }
            if (this.contains(assemblerDescDecl)) {
                ++x;
            }
            if (this.contains(argTDB)) {
                ++x;
            }
            if (this.contains(argMemTDB)) {
                ++x;
            }
            if (this.cmdLineConfig.fusekiCmdLineConfigFile != null) {
                if (x >= 1) {
                    throw new CmdException("Dataset specified on the command line but a configuration file also given.");
                }
            } else if (x > 1) {
                throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --desc");
            }
            boolean bl = cmdlineConfigPresent = x != 0;
            if (cmdlineConfigPresent && this.getPositional().size() == 0) {
                throw new CmdException("Missing service name");
            }
            if (this.cmdLineConfig.fusekiCmdLineConfigFile != null && this.getPositional().size() > 0) {
                throw new CmdException("Service name will come from --conf; no command line service name allowed");
            }
            if (!cmdlineConfigPresent && this.getPositional().size() > 0) {
                throw new CmdException("Service name given but no configuration argument to match (e.g. --mem, --loc/--tdb, --file)");
            }
            if (cmdlineConfigPresent && this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            if (!cmdlineConfigPresent && this.cmdLineConfig.fusekiCmdLineConfigFile == null) {
                FusekiEnv.setEnvironment();
                Path cfg = FusekiEnv.FUSEKI_BASE.resolve("config.ttl").toAbsolutePath();
                if (Files.exists(cfg, new LinkOption[0])) {
                    this.cmdLineConfig.fusekiServerConfigFile = cfg.toString();
                }
            }
            this.cmdLineConfig.allowUpdate = this.contains(argUpdate);
            if (this.contains(argMem)) {
                log2.info("Dataset: in-memory");
                this.cmdLineConfig.datasetDescription = "in-memory";
                this.cmdLineConfig.reset();
                this.cmdLineConfig.argTemplateFile = "templates/config-mem";
                this.cmdLineConfig.allowUpdate = true;
            }
            if (this.contains(argFile)) {
                String filename = this.getValue(argFile);
                log2.info("Dataset: in-memory: load file: " + filename);
                String pathname = filename;
                if (filename.startsWith("file:")) {
                    pathname = filename.substring("file:".length());
                }
                if (!FileOps.exists(filename)) {
                    throw new CmdException("File not found: " + filename);
                }
                this.cmdLineConfig.datasetDescription = "file: " + filename;
                this.cmdLineConfig.reset();
                this.cmdLineConfig.dsg = DatasetGraphFactory.createTxnMem();
                Lang language = RDFLanguages.filenameToLang(filename);
                if (language == null) {
                    throw new CmdException("Can't guess language for file: " + filename);
                }
                Txn.executeWrite(this.cmdLineConfig.dsg, () -> RDFDataMgr.read(this.cmdLineConfig.dsg, filename));
            }
            if (this.contains(argMemTDB)) {
                this.cmdLineConfig.reset();
                this.cmdLineConfig.argTemplateFile = "templates/config-tdb-mem";
                this.cmdLineConfig.params.put("DIR", "--mem--");
                this.cmdLineConfig.allowUpdate = true;
                this.cmdLineConfig.datasetDescription = "TDB dataset (in-memory)";
            }
            if (this.contains(argTDB)) {
                this.cmdLineConfig.reset();
                this.cmdLineConfig.argTemplateFile = "templates/config-tdb-dir";
                dir = this.getValue(argTDB);
                this.cmdLineConfig.params.put("DIR", (String)dir);
                this.cmdLineConfig.datasetDescription = "TDB dataset: " + (String)dir;
            }
            if (this.contains(assemblerDescDecl)) {
                log2.info("Dataset from assembler");
                this.cmdLineConfig.datasetDescription = "Assembler: " + modDataset.getAssemblerFile();
                dir = modDataset.createDataset();
            }
            if (cmdlineConfigPresent) {
                this.cmdLineConfig.datasetPath = this.getPositionalArg(0);
                if (this.cmdLineConfig.datasetPath.length() > 0 && !this.cmdLineConfig.datasetPath.startsWith("/")) {
                    throw new CmdException("Dataset path name must begin with a /: " + this.cmdLineConfig.datasetPath);
                }
                if (!this.cmdLineConfig.allowUpdate) {
                    Fuseki.serverLog.info("Running in read-only mode for " + this.cmdLineConfig.datasetPath);
                }
                this.cmdLineConfig.params.put("NAME", this.cmdLineConfig.datasetPath);
            }
            if (this.contains(argBasicAuth)) {
                Fuseki.configLog.warn("--basic-auth ignored: Use Apache Shiro security - see shiro.ini");
            }
            if (this.contains(argPort)) {
                String portStr = this.getValue(argPort);
                try {
                    this.jettyServerConfig.port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
                }
            }
            if (this.contains(argMgt)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always enabled.  --mgt not needed.");
            }
            if (this.contains(argMgtPort)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always on the same port as the server.  --mgtPort ignored.");
            }
            if (this.contains(argLocalhost)) {
                this.jettyServerConfig.loopback = true;
            }
            if (this.contains(argTimeout)) {
                String str2 = this.getValue(argTimeout);
                ARQ.getContext().set(ARQ.queryTimeout, str2);
            }
            if (this.contains(argJettyConfig)) {
                this.jettyServerConfig.jettyConfigFile = this.getValue(argJettyConfig);
                if (!FileOps.exists(this.jettyServerConfig.jettyConfigFile)) {
                    throw new CmdException("No such file: " + this.jettyServerConfig.jettyConfigFile);
                }
            }
            if (this.contains(argBasicAuth)) {
                Fuseki.configLog.warn("--basic-auth ignored (use Shiro setup instead)");
            }
            if (this.contains(argHome)) {
                Fuseki.configLog.warn("--home ignored (use enviroment variables $FUSEKI_HOME and $FUSEKI_BASE)");
            }
            if (this.contains(argPages)) {
                Fuseki.configLog.warn("--pages ignored (enviroment variables $FUSEKI_HOME to provide the webapp)");
            }
            if (this.contains(argGZip)) {
                if (!this.hasValueOfTrue(argGZip) && !this.hasValueOfFalse(argGZip)) {
                    throw new CmdException(argGZip.getNames().get(0) + ": Not understood: " + this.getValue(argGZip));
                }
                this.jettyServerConfig.enableCompression = super.hasValueOfTrue(argGZip);
            }
        }

        @Override
        protected void exec() {
            try {
                FusekiCmd.runFuseki(this.cmdLineConfig, this.jettyServerConfig);
            }
            catch (FusekiException ex) {
                throw new TerminationException(1);
            }
        }

        @Override
        protected String getCommandName() {
            return "fuseki";
        }
    }
}

