/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.web.HttpSC;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class FusekiErrorHandler
extends ErrorHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        if (!(method.equals(HttpMethod.GET.asString()) || method.equals(HttpMethod.POST.asString()) || method.equals(HttpMethod.HEAD.asString()))) {
            return;
        }
        response.setContentType(MimeTypes.Type.TEXT_PLAIN_UTF_8.asString());
        ServletOps.setNoCache(response);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
        try (Writer writer = IO.asUTF8(bytes);){
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            this.handleErrorPage(request, writer, response.getStatus(), reason);
            if (!Fuseki.VERSION.equalsIgnoreCase("development") && !Fuseki.VERSION.equals("${project.version}")) {
                writer.write("\n");
                writer.write("\n");
                writer.write(String.format("Fuseki - version %s (Build date: %s)\n", Fuseki.VERSION, Fuseki.BUILD_DATE));
            }
            writer.flush();
            response.setContentLength(bytes.size());
            response.getOutputStream().write(bytes.toByteArray());
        }
    }

    @Override
    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        if (message == null) {
            message = HttpSC.getMessage(code);
        }
        writer.write(String.format("Error %d: %s\n", code, message));
        for (Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception"); th != null; th = th.getCause()) {
            writer.write("\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            writer.write(sw.getBuffer().toString());
            writer.write("\n");
        }
    }
}

