/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.build.DatasetDescriptionRegistry;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.build.TemplateFunctions;
import org.apache.jena.fuseki.mgt.ActionContainerItem;
import org.apache.jena.fuseki.mgt.JsonDescription;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiSystem;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.Upload;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.uuid.JenaUUID;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class ActionDatasets
extends ActionContainerItem {
    private static Dataset system = SystemState.getDataset();
    private static DatasetGraphTransaction systemDSG = SystemState.getDatasetGraph();
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static Property pStatus = FusekiVocab.pStatus;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabasetTDB = "tdb";
    private static final String tDatabasetMem = "mem";

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, action.getDataAccessPointRegistry());
        builder.finishObject("D");
        return builder.build();
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        action.log.info(String.format("[%d] GET dataset %s", action.id, action.getDatasetName()));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = (DataAccessPoint)action.getDataAccessPointRegistry().get(action.getDatasetName());
        if (dsDesc == null) {
            ServletOps.errorNotFound("Not found: dataset " + action.getDatasetName());
        }
        JsonDescription.describe(builder, dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        block53: {
            block51: {
                String configFile;
                block52: {
                    JenaUUID uuid2 = JenaUUID.generate();
                    DatasetDescriptionRegistry registry = new DatasetDescriptionRegistry();
                    ContentType ct = FusekiLib.getContentType(action);
                    boolean hasParams = action.request.getParameterNames().hasMoreElements();
                    if (ct == null && !hasParams) {
                        ServletOps.errorBadRequest("Bad request - Content-Type or both parameters dbName and dbType required");
                    }
                    boolean committed = false;
                    system.begin(ReadWrite.WRITE);
                    String systemFileCopy = null;
                    configFile = null;
                    try {
                        String datasetName;
                        Model model = ModelFactory.createDefaultModel();
                        StreamRDF dest = StreamRDFLib.graph(model.getGraph());
                        if (hasParams || WebContent.isHtmlForm(ct)) {
                            ActionDatasets.assemblerFromForm(action, dest);
                        } else if (WebContent.isMultiPartForm(ct)) {
                            ActionDatasets.assemblerFromUpload(action, dest);
                        } else {
                            ActionDatasets.assemblerFromBody(action, dest);
                        }
                        systemFileCopy = FusekiSystem.dirFileArea.resolve(uuid2.asString()).toString();
                        try (OutputStream outCopy = IO.openOutputFile(systemFileCopy);){
                            RDFDataMgr.write(outCopy, model, Lang.TURTLE);
                        }
                        Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
                        if (stmt == null) {
                            StmtIterator sIter = model.listStatements(null, pServiceName, (RDFNode)null);
                            if (!sIter.hasNext()) {
                                ServletOps.errorBadRequest("No name given in description of Fuseki service");
                            }
                            sIter.next();
                            if (sIter.hasNext()) {
                                ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
                            }
                            throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
                        }
                        if (!stmt.getObject().isLiteral()) {
                            ServletOps.errorBadRequest("Found " + FmtUtils.stringForRDFNode(stmt.getObject()) + " : Service names are strings, then used to build the external URI");
                        }
                        Resource subject = stmt.getSubject();
                        Literal object = stmt.getObject().asLiteral();
                        if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
                            action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode(object)));
                        }
                        if ((datasetName = object.getLexicalForm()).isEmpty()) {
                            ServletOps.error(400, "Empty dataset name");
                        }
                        if (StringUtils.isBlank(datasetName)) {
                            ServletOps.error(400, String.format("Whitespace dataset name: '%s'", datasetName));
                        }
                        if (datasetName.contains(" ")) {
                            ServletOps.error(400, String.format("Bad dataset name (contains spaces) '%s'", datasetName));
                        }
                        if (datasetName.equals("/")) {
                            ServletOps.error(400, String.format("Bad dataset name '%s'", datasetName));
                        }
                        String datasetPath = DataAccessPoint.canonical(datasetName);
                        action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
                        if (action.getDataAccessPointRegistry().isRegistered(datasetPath)) {
                            ServletOps.error(409, "Name already registered " + datasetPath);
                        }
                        configFile = FusekiSystem.generateConfigurationFilename(datasetPath);
                        List<String> existing = FusekiSystem.existingConfigurationFile(datasetPath);
                        if (!existing.isEmpty()) {
                            ServletOps.error(409, "Configuration file for '" + datasetPath + "' already exists");
                        }
                        try (OutputStream outCopy = IO.openOutputFile(configFile);){
                            RDFDataMgr.write(outCopy, model, Lang.TURTLE);
                        }
                        DataAccessPoint ref = FusekiBuilder.buildDataAccessPoint(subject, registry);
                        action.getDataAccessPointRegistry().register(datasetPath, ref);
                        action.getResponse().setContentType("text/plain");
                        ServletOps.success(action);
                        system.commit();
                        committed = true;
                        if (committed) break block51;
                        if (systemFileCopy == null) break block52;
                    }
                    catch (IOException ex) {
                        IO.exception(ex);
                        break block53;
                    }
                    finally {
                        if (!committed) {
                            if (systemFileCopy != null) {
                                FileOps.deleteSilent(systemFileCopy);
                            }
                            if (configFile != null) {
                                FileOps.deleteSilent(configFile);
                            }
                            system.abort();
                        }
                        system.end();
                    }
                    FileOps.deleteSilent(systemFileCopy);
                }
                if (configFile != null) {
                    FileOps.deleteSilent(configFile);
                }
                system.abort();
            }
            system.end();
        }
        return null;
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        String s;
        DataService dSrv;
        String name = action.getDatasetName();
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        if (action.getDataAccessPoint() == null) {
            ServletOps.errorNotFound("Not found: dataset " + action.getDatasetName());
        }
        if ((dSrv = action.getDataService()) == null) {
            dSrv = action.getDataAccessPoint().getDataService();
        }
        if ((s = action.request.getParameter("state")) == null || s.isEmpty()) {
            ServletOps.errorBadRequest("No state change given");
        }
        if (s.equalsIgnoreCase("active")) {
            action.log.info(String.format("[%d] REBUILD DATASET %s", action.id, name));
            ActionDatasets.setDatasetState(name, FusekiVocab.stateActive);
            dSrv.goActive();
        } else if (s.equalsIgnoreCase("offline")) {
            action.log.info(String.format("[%d] OFFLINE DATASET %s", action.id, name));
            dSrv.goOffline();
            ActionDatasets.setDatasetState(name, FusekiVocab.stateOffline);
        } else if (s.equalsIgnoreCase("unlink")) {
            action.log.info(String.format("[%d] UNLINK ACCESS NAME %s", action.id, name));
            ServletOps.errorNotImplemented("unlink: dataset" + action.getDatasetName());
        } else {
            ServletOps.errorBadRequest("State change operation '" + s + "' not recognized");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execDeleteItem(HttpAction action) {
        String name = action.getDatasetName();
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE ds=%s", action.id, name));
        if (!action.getDataAccessPointRegistry().isRegistered(name)) {
            ServletOps.errorNotFound("No such dataset registered: " + name);
        }
        systemDSG.begin(ReadWrite.WRITE);
        boolean committed = false;
        try {
            DataAccessPoint ref = (DataAccessPoint)action.getDataAccessPointRegistry().get(name);
            if (ref == null) {
                ServletOps.errorNotFound("No such dataset registered: " + name);
            }
            action.getDataAccessPointRegistry().remove(name);
            String filename = name.startsWith("/") ? name.substring(1) : name;
            FusekiSystem.existingConfigurationFile(filename).stream().forEach(FileOps::deleteSilent);
            Node n = NodeFactory.createLiteral(DataAccessPoint.canonical(name));
            Quad q = ActionDatasets.getOne(systemDSG, null, null, pServiceName.asNode(), n);
            if (q != null) {
                Node gn = q.getGraph();
                systemDSG.deleteAny(gn, null, null, null);
            }
            systemDSG.commit();
            committed = true;
            ServletOps.success(action);
        }
        finally {
            if (!committed) {
                systemDSG.abort();
            }
            systemDSG.end();
        }
        action.getDataAccessPointRegistry().remove(name);
    }

    private static void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private static void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String dbType = action.getRequest().getParameter(paramDatasetType);
        String dbName = action.getRequest().getParameter(paramDatasetName);
        if (StringUtils.isBlank(dbType) || StringUtils.isBlank(dbName)) {
            ServletOps.errorBadRequest("Required parameters: dbName and dbType");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (dbName.startsWith("/")) {
            params.put("NAME", dbName.substring(1));
        } else {
            params.put("NAME", dbName);
        }
        FusekiSystem.addGlobals(params);
        if (!dbType.equals(tDatabasetTDB) && !dbType.equals(tDatabasetMem)) {
            ServletOps.errorBadRequest(String.format("dbType can be only '%s' or '%s'", tDatabasetTDB, tDatabasetMem));
        }
        String template = null;
        if (dbType.equalsIgnoreCase(tDatabasetTDB)) {
            template = TemplateFunctions.templateFile("templates/config-tdb", params, Lang.TTL);
        }
        if (dbType.equalsIgnoreCase(tDatabasetMem)) {
            template = TemplateFunctions.templateFile("templates/config-mem", params, Lang.TTL);
        }
        RDFParser.create().source(new StringReader(template)).base("http://base/").lang(Lang.TTL).parse(dest);
    }

    private static void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        Upload.fileUploadWorker(action, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDatasetState(String name, Resource newState) {
        boolean committed = false;
        system.begin(ReadWrite.WRITE);
        try {
            String dbName = name;
            if (dbName.startsWith("/")) {
                dbName = dbName.substring(1);
            }
            String update2 = StrUtils.strjoinNL(SystemState.PREFIXES, "DELETE { GRAPH ?g { ?s fu:status ?state } }", "INSERT { GRAPH ?g { ?s fu:status " + FmtUtils.stringForRDFNode(newState) + " } }", "WHERE {", "   GRAPH ?g { ?s fu:name '" + dbName + "' ; ", "                 fu:status ?state .", "   }", "}");
            UpdateRequest req = UpdateFactory.create(update2);
            UpdateAction.execute(req, system);
            system.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                system.abort();
            }
            system.end();
        }
    }

    private static Quad getOne(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = dsg.findNG(g, s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Quad q = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return q;
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.request;
        String base = ActionLib.wholeRequestURL(request);
        ContentType ct = FusekiLib.getContentType(request);
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentType());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return;
        }
        ServletInputStream input = null;
        try {
            input = request.getInputStream();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        dest.prefix("root", base + "#");
        ActionLib.parse(action, dest, input, lang, base);
    }
}

