/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.ActionCtl;
import org.apache.jena.fuseki.mgt.JsonDescription;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionServerStatus
extends ActionCtl {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doCommon(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doCommon(req, resp);
    }

    @Override
    protected void perform(HttpAction action) {
        try {
            this.description(action);
            ServletOps.success(action);
        }
        catch (IOException e2) {
            ServletOps.errorOccurred(e2);
        }
    }

    private void description(HttpAction action) throws IOException {
        ServletOutputStream out = action.response.getOutputStream();
        action.response.setContentType("application/json");
        action.response.setCharacterEncoding("utf-8");
        JsonBuilder builder = new JsonBuilder();
        builder.startObject();
        this.describeServer(builder, action.request.getLocalPort());
        this.describeDatasets(builder, action.getDataAccessPointRegistry());
        builder.finishObject();
        JsonValue v = builder.build();
        JSON.write(out, v);
        out.println();
        out.flush();
    }

    private void describeServer(JsonBuilder builder, int requestPort) {
        String versionStr = Fuseki.VERSION;
        String builtDateStr = Fuseki.BUILD_DATE;
        if (versionStr == null || versionStr.startsWith("${")) {
            versionStr = "Development";
        }
        if (builtDateStr == null || builtDateStr.startsWith("${")) {
            builtDateStr = "Unknown";
        }
        builder.key("version").value(versionStr).key("built").value(builtDateStr).key("startDateTime").value(Fuseki.serverStartedAt()).key("uptime").value(Fuseki.serverUptimeSeconds());
    }

    private void describeDatasets(JsonBuilder builder, DataAccessPointRegistry registry) {
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, registry);
    }
}

