/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.async.AsyncTask;
import org.apache.jena.fuseki.servlets.ActionBase;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionTasks
extends ActionBase {
    private static AsyncPool[] pools = new AsyncPool[]{AsyncPool.get()};
    private static String prefix = "/";

    public ActionTasks() {
        super(Fuseki.serverLog);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void execCommonWorker(HttpAction action) {
        String method;
        String name = ActionTasks.extractItemName(action);
        if (name != null) {
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
            } else {
                this.log.warn("Unexpected task name : " + name);
            }
        }
        if ((method = action.request.getMethod()).equals("GET")) {
            this.execGet(action, name);
        } else if (method.equals("POST")) {
            this.execPost(action, name);
        } else {
            ServletOps.error(405);
        }
    }

    private void execGet(HttpAction action, String name) {
        if (name == null) {
            this.log.info(String.format("[%d] Tasks", action.id));
        } else {
            this.log.info(String.format("[%d] Task %s", action.id, name));
        }
        JsonValue responseBody = null;
        if (name == null) {
            JsonBuilder builder = new JsonBuilder();
            builder.startArray();
            for (AsyncPool pool : pools) {
                for (AsyncTask aTask : pool.tasks()) {
                    ActionTasks.descOneTask(builder, aTask);
                }
            }
            builder.finishArray();
            responseBody = builder.build();
        } else {
            for (AsyncPool pool : pools) {
                AsyncTask aTask = pool.getTask(name);
                if (aTask == null) continue;
                JsonBuilder builder = new JsonBuilder();
                ActionTasks.descOneTask(builder, aTask);
                responseBody = builder.build();
            }
        }
        if (responseBody == null) {
            ServletOps.errorNotFound("Task '" + name + "' not found");
        }
        ServletOps.setNoCache(action);
        ServletOps.sendJsonReponse(action, responseBody);
    }

    private void execPost(HttpAction action, String name) {
    }

    private static void descOneTask(JsonBuilder builder, AsyncTask aTask) {
        builder.startObject("SingleTask");
        builder.key("task").value(aTask.displayName());
        builder.key("taskId").value(aTask.getTaskId());
        if (aTask.getStartPoint() != null) {
            builder.key("started").value(aTask.getStartPoint());
        }
        if (aTask.getFinishPoint() != null) {
            builder.key("finished").value(aTask.getFinishPoint());
        }
        builder.finishObject("SingleTask");
    }
}

