/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.FusekiSystem;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;

public class Backup {
    private static Set<DatasetGraph> activeBackups = Collections.newSetFromMap(new ConcurrentHashMap());

    public static String chooseFileName(String dsName) {
        String ds = dsName;
        if (ds.startsWith("/")) {
            ds = ds.substring(1);
        }
        if (ds.contains("/")) {
            Fuseki.adminLog.warn("Dataset name: weird format: " + dsName);
            ds = ds.replace("/", "_");
        }
        String timestamp = DateTimeUtils.nowAsString("yyyy-MM-dd_HH-mm-ss");
        String filename = ds + "_" + timestamp;
        filename = FusekiSystem.dirBackups.resolve(filename).toString();
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup(Transactional transactional, DatasetGraph dsg, String backupfile) {
        if (transactional == null) {
            transactional = new TransactionalNull();
        }
        transactional.begin(ReadWrite.READ);
        try {
            Backup.backup(dsg, backupfile);
        }
        catch (Exception ex) {
            Log.warn(Fuseki.serverLog, "Exception in backup", (Throwable)ex);
        }
        finally {
            transactional.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backup(DatasetGraph dsg, String backupfile) {
        if (!backupfile.endsWith(".nq")) {
            backupfile = backupfile + ".nq";
        }
        Set<DatasetGraph> set = activeBackups;
        synchronized (set) {
            if (activeBackups.contains(dsg)) {
                Log.warn(Fuseki.serverLog, "Backup already in progress");
            }
            activeBackups.add(dsg);
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(backupfile + ".gz");
            out = new GZIPOutputStream(out, 8192);
            out = new BufferedOutputStream(out);
            RDFDataMgr.write(out, dsg, Lang.NQUADS);
            out.close();
            out = null;
        }
        catch (FileNotFoundException e2) {
            Log.warn(Fuseki.serverLog, "File not found: " + backupfile);
            throw new FusekiException("File not found: " + backupfile);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            Set<DatasetGraph> set2 = activeBackups;
            synchronized (set2) {
                activeBackups.remove(dsg);
            }
        }
    }
}

