/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiInitialConfig;
import org.apache.jena.fuseki.server.Operation;
import org.slf4j.Logger;

public class FusekiInfo {
    public static void info(FusekiInitialConfig serverConfig, DataAccessPointRegistry registry) {
        if (!serverConfig.verbose) {
            return;
        }
        if (serverConfig.quiet) {
            return;
        }
        Logger log2 = Fuseki.serverLog;
        FmtLog.info(log2, "Apache Jena Fuseki", new Object[0]);
        Map<String, List<String>> z = FusekiInfo.description(registry);
        if (serverConfig.datasetPath != null) {
            if (z.size() != 1) {
                log2.error("Expected only one dataset");
            }
            List<String> endpoints2 = z.get(serverConfig.datasetPath);
            FmtLog.info(log2, "Dataset Type = %s", serverConfig.datasetDescription);
            FmtLog.info(log2, "Path = %s; Services = %s", serverConfig.datasetPath, endpoints2);
        }
        if (serverConfig.fusekiServerConfigFile != null) {
            FmtLog.info(log2, "Configuration file %s", serverConfig.fusekiServerConfigFile);
            z.forEach((name, endpoints) -> FmtLog.info(log2, "Path = %s; Services = %s", name, endpoints));
        }
        FusekiInfo.logDetails(log2);
    }

    private static Map<String, List<String>> description(DataAccessPointRegistry reg) {
        LinkedHashMap<String, List<String>> desc = new LinkedHashMap<String, List<String>>();
        reg.forEach((ds, dap) -> {
            ArrayList endpoints = new ArrayList();
            desc.put((String)ds, endpoints);
            DataService dSrv = dap.getDataService();
            dSrv.getOperations().forEach(op -> dSrv.getEndpoints((Operation)op).forEach(ep -> {
                String x = ep.getEndpoint();
                if (x.isEmpty()) {
                    x = "quads";
                }
                endpoints.add(x);
            }));
        });
        return desc;
    }

    public static void logDetails(Logger log2) {
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        Function<Long, String> f = FusekiInfo::strNum2;
        FmtLog.info(log2, "  Fuseki: %s", Fuseki.VERSION);
        FmtLog.info(log2, "  Java:   %s", System.getProperty("java.version"));
        FmtLog.info(log2, "  Memory: max=%s", f.apply(maxMem));
        FmtLog.info(log2, "  OS:     %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static void logDetailsVerbose(Logger log2) {
        FusekiInfo.logDetails(log2);
        FusekiInfo.logOne(log2, "java.vendor");
        FusekiInfo.logOne(log2, "java.home");
        FusekiInfo.logOne(log2, "java.runtime.version");
        FusekiInfo.logOne(log2, "java.runtime.name");
        FusekiInfo.logOne(log2, "user.language");
        FusekiInfo.logOne(log2, "user.timezone");
        FusekiInfo.logOne(log2, "user.country");
        FusekiInfo.logOne(log2, "user.dir");
    }

    private static void logOne(Logger log2, String property) {
        FmtLog.info(log2, "    %-20s = %s", property, System.getProperty(property));
    }

    public static String strNumMixed(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1fK", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1fM", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1fG", (double)x / 1.073741824E9);
        }
        return String.format("%.1fT", (double)x / 1.099511627776E12);
    }

    public static String strNum10(long x) {
        if (x < 1000L) {
            return Long.toString(x);
        }
        if (x < 1000000L) {
            return String.format("%.1fK", (double)x / 1000.0);
        }
        if (x < 1000000000L) {
            return String.format("%.1fM", (double)x / 1000000.0);
        }
        if (x < 1000000000000L) {
            return String.format("%.1fG", (double)x / 1.0E9);
        }
        return String.format("%.1fT", (double)x / 1.0E12);
    }

    public static String strNum2(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1f KiB", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1f MiB", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1f GiB", (double)x / 1.073741824E9);
        }
        return String.format("%.1fTiB", (double)x / 1.099511627776E12);
    }
}

