/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiInfo;
import org.apache.jena.fuseki.server.FusekiInitialConfig;
import org.apache.jena.fuseki.server.FusekiSystem;
import org.apache.jena.fuseki.servlets.ServiceDispatchRegistry;
import org.apache.jena.tdb.StoreConnection;

public class FusekiServerListener
implements ServletContextListener {
    public static FusekiInitialConfig initialSetup = null;
    private boolean initialized = false;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String x = servletContext.getContextPath();
        if (!x.isEmpty()) {
            Fuseki.configLog.info("Context path = " + x);
        }
        this.serverInitialization(servletContext);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        StoreConnection.reset();
    }

    private synchronized void serverInitialization(ServletContext servletContext) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        ServiceDispatchRegistry serviceDispatchRegistry = new ServiceDispatchRegistry(true);
        ServiceDispatchRegistry.set(servletContext, serviceDispatchRegistry);
        DataAccessPointRegistry dataAccessPointRegistry = new DataAccessPointRegistry();
        DataAccessPointRegistry.set(servletContext, dataAccessPointRegistry);
        try {
            FusekiSystem.formatBaseArea();
            if (!FusekiSystem.serverInitialized) {
                Fuseki.serverLog.error("Failed to initialize : Server not running");
                return;
            }
            if (initialSetup == null) {
                String cfg;
                initialSetup = new FusekiInitialConfig();
                FusekiServerListener.initialSetup.fusekiServerConfigFile = cfg = FusekiEnv.FUSEKI_BASE.resolve("config.ttl").toAbsolutePath().toString();
            }
            if (initialSetup == null) {
                Fuseki.serverLog.error("No configuration");
                throw new FusekiException("No configuration");
            }
            Fuseki.setVerbose(servletContext, FusekiServerListener.initialSetup.verbose);
            FusekiSystem.initializeDataAccessPoints(dataAccessPointRegistry, initialSetup, FusekiSystem.dirConfiguration.toString());
        }
        catch (Throwable th) {
            Fuseki.serverLog.error("Exception in initialization: {}", (Object)th.getMessage());
            throw th;
        }
        FusekiInfo.info(initialSetup, dataAccessPointRegistry);
    }
}

