/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DatasetStatus;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.IRIResolver;

public class FusekiVocab {
    public static String NS = "http://jena.apache.org/fuseki#";
    private static Model model = ModelFactory.createDefaultModel();
    public static final Resource tServer = FusekiVocab.resource("Server");
    public static final Resource fusekiService = FusekiVocab.resource("Service");
    public static final Property pServices = FusekiVocab.property("services");
    public static final Property pServiceName = FusekiVocab.property("name");
    public static final Property pServiceQueryEP = FusekiVocab.property("serviceQuery");
    public static final Property pServiceUpdateEP = FusekiVocab.property("serviceUpdate");
    public static final Property pServiceUploadEP = FusekiVocab.property("serviceUpload");
    public static final Property pServiceReadWriteGraphStoreEP = FusekiVocab.property("serviceReadWriteGraphStore");
    public static final Property pServiceReadGraphStoreEP = FusekiVocab.property("serviceReadGraphStore");
    public static final Property pServiceReadWriteQuadsEP = FusekiVocab.property("serviceReadWriteQuads");
    public static final Property pServiceReadQuadsEP = FusekiVocab.property("serviceReadQuads");
    public static final Property pAllowTimeoutOverride = FusekiVocab.property("allowTimeoutOverride");
    public static final Property pMaximumTimeoutOverride = FusekiVocab.property("maximumTimeoutOverride");
    private static final String stateNameActive = DatasetStatus.ACTIVE.name;
    private static final String stateNameOffline = DatasetStatus.OFFLINE.name;
    private static final String stateNameClosing = DatasetStatus.CLOSING.name;
    private static final String stateNameClosed = DatasetStatus.CLOSED.name;
    public static final Resource stateActive = FusekiVocab.resource(stateNameActive);
    public static final Resource stateOffline = FusekiVocab.resource(stateNameOffline);
    public static final Resource stateClosing = FusekiVocab.resource(stateNameClosing);
    public static final Resource stateClosed = FusekiVocab.resource(stateNameClosed);
    public static final Property pStatus = FusekiVocab.property("status");

    private static Resource resource(String localname2) {
        return model.createResource(FusekiVocab.iri(localname2));
    }

    private static Property property(String localname2) {
        return model.createProperty(FusekiVocab.iri(localname2));
    }

    private static String iri(String localname2) {
        String uri = NS + localname2;
        IRI iri2 = IRIResolver.parseIRI(uri);
        if (iri2.hasViolation(true)) {
            throw new FusekiException("Bad IRI: " + iri2);
        }
        if (!iri2.isAbsolute()) {
            throw new FusekiException("Bad IRI: " + iri2);
        }
        return uri;
    }
}

