/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ServiceRouter;
import org.slf4j.Logger;

public class FusekiFilter
implements Filter {
    private static Logger log = Fuseki.serverLog;
    private static ServiceRouter routerServlet = new ServiceRouter.AccessByConfig();
    private static final boolean LogFilter = false;

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            String uri = ActionLib.actionURI(req);
            String datasetUri = ActionLib.mapActionRequestToDataset(uri);
            DataAccessPointRegistry registry = DataAccessPointRegistry.get(request.getServletContext());
            if (datasetUri != null && registry.isRegistered(datasetUri)) {
                routerServlet.doCommon(req, resp);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

