/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.REST_Quads;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;

public class REST_Quads_R
extends REST_Quads {
    @Override
    protected void validate(HttpAction action) {
        String method;
        switch (method = action.getRequest().getMethod()) {
            case "GET": 
            case "HEAD": 
            case "OPTIONS": {
                break;
            }
            default: {
                ServletOps.errorMethodNotAllowed(method + " : Read-only dataset");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpAction action) {
        ServletOutputStream output;
        MediaType mediaType = ActionLib.contentNegotationQuads(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream(output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentType());
        if (lang == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (!RDFLanguages.isQuads(lang)) {
            ServletOps.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            action.response.setHeader("Content-type", lang.getContentType().toHeaderString());
            RDFFormat fmt = lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization(lang);
            try {
                RDFDataMgr.write((OutputStream)out, dsg, fmt);
            }
            catch (JenaException ex) {
                if (fmt.getLang().equals(Lang.RDFXML)) {
                    ServletOps.errorBadRequest("Failed to write output in RDF/XML: " + ex.getMessage());
                }
                ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        action.response.setHeader("Allow", "GET, HEAD, OPTIONS");
        action.response.setHeader("Content-Length", "0");
        ServletOps.success(action);
    }

    @Override
    protected void doHead(HttpAction action) {
        action.beginRead();
        try {
            MediaType mediaType = ActionLib.contentNegotationQuads(action);
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }
}

