/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.REST_Quads_R;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.Upload;
import org.apache.jena.fuseki.servlets.UploadDetails;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class REST_Quads_RW
extends REST_Quads_R {
    @Override
    protected void validate(HttpAction action) {
    }

    @Override
    protected void doOptions(HttpAction action) {
        REST_Quads_RW.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,POST");
        action.response.setHeader("Content-Length", "0");
        ServletOps.success(action);
    }

    @Override
    protected void doPost(HttpAction action) {
        if (!action.getDataService().allowUpdate()) {
            ServletOps.errorMethodNotAllowed("POST");
        }
        if (action.isTransactional()) {
            this.doPutPostTxn(action, false);
        } else {
            this.doPutPostNonTxn(action, false);
        }
    }

    @Override
    protected void doPut(HttpAction action) {
        if (!action.getDataService().allowUpdate()) {
            ServletOps.errorMethodNotAllowed("POST");
        }
        if (action.isTransactional()) {
            this.doPutPostTxn(action, true);
        } else {
            this.doPutPostNonTxn(action, true);
        }
    }

    @Override
    protected void doDelete(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPatch(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PATCH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutPostTxn(HttpAction action, boolean clearFirst) {
        UploadDetails details = null;
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            if (clearFirst) {
                dsg.clear();
            }
            StreamRDF dest = StreamRDFLib.dataset(dsg);
            details = Upload.incomingData(action, dest);
            action.commit();
            ServletOps.success(action);
        }
        catch (RiotException ex) {
            action.abort();
            ServletOps.errorBadRequest(ex.getMessage());
        }
        catch (ActionErrorException ex) {
            action.abort();
            throw ex;
        }
        catch (Exception ex) {
            action.abort();
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutPostNonTxn(HttpAction action, boolean clearFirst) {
        UploadDetails details;
        DatasetGraph dsgTmp = DatasetGraphFactory.create();
        StreamRDF dest = StreamRDFLib.dataset(dsgTmp);
        try {
            details = Upload.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return;
        }
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            if (clearFirst) {
                dsg.clear();
            }
            FusekiLib.addDataInto(dsgTmp, dsg);
            action.commit();
            ServletOps.success(action);
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
        ServletOps.uploadResponse(action, details);
    }
}

