/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.conneg.WebLib;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.JenaException;

public class ResponseDataset {
    private static final String contentOutputJSONLD = "json-ld";
    private static final String contentOutputJSONRDF = "json-rdf";
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputText = "text";
    private static final String contentOutputTTL = "ttl";
    private static final String contentOutputNT = "nt";
    private static final String contentOutputTriG = "trig";
    private static final String contentOutputNQuads = "n-quads";
    public static Map<String, String> shortNamesModel = new HashMap<String, String>();

    public static void doResponseModel(HttpAction action, Model model) {
        Dataset ds = DatasetFactory.create(model);
        ResponseDataset.doResponseDataset(action, ds);
    }

    public static void doResponseDataset(HttpAction action, Dataset dataset) {
        block13: {
            Lang lang;
            String outputField;
            HttpServletRequest request = action.request;
            HttpServletResponseTracker response = action.response;
            String mimeType = null;
            MediaType i = ConNeg.chooseContentType(request, DEF.constructOffer, DEF.acceptTurtle);
            if (i != null) {
                mimeType = i.getContentType();
            }
            if ((outputField = ResponseOps.paramOutput(request, shortNamesModel)) != null) {
                mimeType = outputField;
            }
            String writerMimeType = mimeType;
            if (mimeType == null) {
                Fuseki.actionLog.warn("Can't find MIME type for response");
                String x = WebLib.getAccept(request);
                String msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
                ServletOps.error(406, msg);
            }
            String contentType = mimeType;
            String charset = "utf-8";
            String forceAccept = ResponseOps.paramForceAccept(request);
            if (forceAccept != null) {
                contentType = forceAccept;
                charset = "utf-8";
            }
            if ((lang = RDFLanguages.contentTypeToLang(contentType)) == null) {
                ServletOps.errorBadRequest("Can't determine output content type: " + contentType);
            }
            try {
                ResponseOps.setHttpResponse(action, contentType, charset);
                response.setStatus(200);
                ServletOutputStream out = response.getOutputStream();
                try {
                    if (RDFLanguages.isQuads(lang)) {
                        RDFDataMgr.write((OutputStream)out, dataset, lang);
                    } else {
                        RDFDataMgr.write((OutputStream)out, dataset.getDefaultModel(), lang);
                    }
                    out.flush();
                }
                catch (JenaException ex) {
                    if (lang.equals(Lang.RDFXML)) {
                        ServletOps.errorBadRequest("Failed to write output in RDF/XML: " + ex.getMessage());
                        break block13;
                    }
                    ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
                }
            }
            catch (ActionErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                action.log.info("Exception while writing the response model: " + ex.getMessage(), ex);
                ServletOps.errorOccurred("Exception while writing the response model: " + ex.getMessage(), ex);
            }
        }
    }

    static {
        ResponseOps.put(shortNamesModel, contentOutputJSONLD, "application/ld+json");
        ResponseOps.put(shortNamesModel, contentOutputJSONRDF, "application/rdf+json");
        ResponseOps.put(shortNamesModel, contentOutputJSON, "application/ld+json");
        ResponseOps.put(shortNamesModel, contentOutputXML, "application/rdf+xml");
        ResponseOps.put(shortNamesModel, contentOutputText, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputTTL, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputNT, "application/n-triples");
        ResponseOps.put(shortNamesModel, contentOutputNQuads, "application/n-quads");
        ResponseOps.put(shortNamesModel, contentOutputTriG, "text/trig");
    }
}

