/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.XMLOutput;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResultSet {
    private static Logger xlog = LoggerFactory.getLogger(ResponseResultSet.class);
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputSPARQL = "sparql";
    private static final String contentOutputText = "text";
    private static final String contentOutputCSV = "csv";
    private static final String contentOutputTSV = "tsv";
    private static final String contentOutputThrift = "thrift";
    public static Map<String, String> shortNamesResultSet = new HashMap<String, String>();

    public static void doResponseResultSet(HttpAction action, Boolean booleanResult) {
        ResponseResultSet.doResponseResultSet$(action, null, booleanResult, null, DEF.rsOfferBoolean);
    }

    public static void doResponseResultSet(HttpAction action, ResultSet resultSet, Prologue qPrologue) {
        ResponseResultSet.doResponseResultSet$(action, resultSet, null, qPrologue, DEF.rsOfferTable);
    }

    private static void doResponseResultSet$(HttpAction action, ResultSet resultSet, Boolean booleanResult, Prologue qPrologue, AcceptList contentTypeOffer) {
        String forceAccept;
        String outputField;
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        long id = action.id;
        if (resultSet == null && booleanResult == null) {
            xlog.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            xlog.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, contentTypeOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesResultSet)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        String stylesheetURL = ResponseOps.paramStylesheet(request);
        if (stylesheetURL != null && Objects.equals(serializationType, "application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseOps.paramForceAccept(request)) != null) {
            contentType = "text/plain";
        }
        if (Objects.equals(serializationType, "text/plain")) {
            ResponseResultSet.textOutput(action, contentType, resultSet, qPrologue, booleanResult);
            return;
        }
        Lang lang = WebContent.contentTypeToLangResultSet(serializationType);
        if (lang == null) {
            ServletOps.errorBadRequest("Not recognized for SPARQL results: " + serializationType);
        }
        if (!ResultSetWriterRegistry.isRegistered(lang)) {
            ServletOps.errorBadRequest("No results writer for " + serializationType);
        }
        Context cxt = action.getContext().copy();
        String charset = "utf-8";
        String jsonCallback = null;
        if (Objects.equals(serializationType, "application/sparql-results+xml")) {
            charset = null;
            XMLOutput.setStylesheetURL(cxt, stylesheetURL);
        }
        if (Objects.equals(serializationType, "application/sparql-results+json")) {
            jsonCallback = ResponseOps.paramCallback(action.request);
        }
        if (Objects.equals(serializationType, "application/sparql-results+thrift")) {
            if (booleanResult != null) {
                ServletOps.errorBadRequest("Can't write a boolean result in thrift");
            }
            charset = null;
        }
        ResponseResultSet.generalOutput(action, lang, contentType, charset, cxt, jsonCallback, resultSet, booleanResult);
    }

    private static void textOutput(HttpAction action, String contentType, ResultSet resultSet, Prologue qPrologue, Boolean booleanResult) {
        OutputContent proc = out -> {
            if (resultSet != null) {
                ResultSetFormatter.out((OutputStream)out, resultSet, qPrologue);
            }
            if (booleanResult != null) {
                ResultSetFormatter.out((OutputStream)out, booleanResult);
            }
        };
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    private static void generalOutput(HttpAction action, Lang rsLang, String contentType, String charset, Context context, String callback, ResultSet resultSet, Boolean booleanResult) {
        ResultsWriter rw = ResultsWriter.create().lang(rsLang).context(context).build();
        OutputContent proc = out -> {
            if (callback != null) {
                String callbackFunction = callback;
                callbackFunction = callbackFunction.replace("\r", "");
                callbackFunction = callbackFunction.replace("\n", "");
                out.print(callbackFunction);
                out.println("(");
            }
            if (resultSet != null) {
                rw.write((OutputStream)out, resultSet);
            }
            if (booleanResult != null) {
                rw.write((OutputStream)out, (boolean)booleanResult);
            }
            if (callback != null) {
                out.println(")");
            }
        };
        ResponseResultSet.output(action, contentType, charset, proc);
    }

    private static void output(HttpAction action, String contentType, String charset, OutputContent proc) {
        try {
            ResponseOps.setHttpResponse(action, contentType, charset);
            action.response.setStatus(200);
            ServletOutputStream out = action.response.getOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                action.log.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                out.println();
                out.println("##  Query cancelled due to timeout during execution   ##");
                out.println("##  ****          Incomplete results           ****   ##");
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    static {
        ResponseOps.put(shortNamesResultSet, contentOutputJSON, "application/sparql-results+json");
        ResponseOps.put(shortNamesResultSet, contentOutputSPARQL, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputXML, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputText, "text/plain");
        ResponseOps.put(shortNamesResultSet, contentOutputCSV, "text/csv");
        ResponseOps.put(shortNamesResultSet, contentOutputTSV, "text/tab-separated-values");
        ResponseOps.put(shortNamesResultSet, contentOutputThrift, "application/sparql-results+thrift");
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1) throws IOException;
    }
}

