/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.REST_Quads_R;
import org.apache.jena.fuseki.servlets.REST_Quads_RW;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_R;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_RW;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class SPARQL_UberServlet_Original
extends ActionService {
    private final ActionService queryServlet = new SPARQL_QueryDataset();
    private final ActionService updateServlet = new SPARQL_Update();
    private final ActionService uploadServlet = new SPARQL_Upload();
    private final ActionService gspServlet_R = new SPARQL_GSP_R();
    private final ActionService gspServlet_RW = new SPARQL_GSP_RW();
    private final ActionService restQuads_R = new REST_Quads_R();
    private final ActionService restQuads_RW = new REST_Quads_RW();

    protected abstract boolean allowQuery(HttpAction var1);

    protected abstract boolean allowUpdate(HttpAction var1);

    protected abstract boolean allowREST_R(HttpAction var1);

    protected abstract boolean allowREST_W(HttpAction var1);

    protected abstract boolean allowQuadsR(HttpAction var1);

    protected abstract boolean allowQuadsW(HttpAction var1);

    private String getEPName(String dsname, List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        String x = endpoints.get(0);
        x = !dsname.endsWith("/") ? dsname + "/" + x : dsname + x;
        return x;
    }

    @Override
    protected void validate(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.validate");
    }

    @Override
    protected void perform(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.perform");
    }

    @Override
    protected String mapRequestToDataset(HttpAction action) {
        String uri = ActionLib.removeContextPath(action);
        return ActionLib.mapRequestToDatasetLongest$(uri, action.getDataAccessPointRegistry());
    }

    @Override
    protected void executeAction(HttpAction action) {
        long id = action.id;
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        String actionURI = action.getActionURI();
        String method = request.getMethod();
        DataAccessPoint desc = action.getDataAccessPoint();
        DataService dSrv = action.getDataService();
        String trailing = this.findTrailing(actionURI, desc.getName());
        String qs = request.getQueryString();
        boolean hasParams = request.getParameterMap().size() > 0;
        boolean isQuery = request.getParameter("query") != null;
        boolean isUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean hasParamGraphDefault = request.getParameter("default") != null;
        boolean hasTrailing = trailing.length() != 0;
        String ct = request.getContentType();
        String charset = request.getCharacterEncoding();
        MediaType mt = null;
        if (ct != null) {
            mt = MediaType.create(ct, charset);
            if ("application/sparql-query".equalsIgnoreCase(ct)) {
                isQuery = true;
            } else if ("application/sparql-update".equalsIgnoreCase(ct)) {
                isUpdate = true;
            }
        }
        if (action.log.isInfoEnabled()) {
            action.log.info(String.format("[%d] %s %s :: '%s' :: %s ? %s", id, method, desc.getName(), trailing, mt == null ? "<none>" : mt, qs == null ? "" : qs));
        }
        if (!hasTrailing) {
            if (isQuery) {
                if (!this.allowQuery(action)) {
                    ServletOps.errorMethodNotAllowed("SPARQL query : " + method);
                }
                this.executeRequest(action, this.queryServlet);
                return;
            }
            if (isUpdate) {
                if (!this.allowUpdate(action)) {
                    ServletOps.errorMethodNotAllowed("SPARQL update : " + method);
                }
                this.executeRequest(action, this.updateServlet);
                return;
            }
            if (hasParamGraph || hasParamGraphDefault) {
                this.doGraphStoreProtocol(action);
                return;
            }
            if (hasParams) {
                ServletOps.errorBadRequest("Malformed request");
            }
            boolean isGET = method.equals("GET");
            boolean isHEAD = method.equals("HEAD");
            if (isGET || isHEAD) {
                if (this.allowQuadsR(action)) {
                    this.restQuads_R.executeLifecycle(action);
                } else {
                    ServletOps.errorMethodNotAllowed(method);
                }
                return;
            }
            if (this.allowQuadsW(action)) {
                this.restQuads_RW.executeLifecycle(action);
            } else {
                ServletOps.errorMethodNotAllowed("Read-only dataset : " + method);
            }
            return;
        }
        boolean checkForPossibleService = true;
        if (action.getEndpoint() != null) {
            if (this.serviceDispatch(action, Operation.Query, this.queryServlet)) {
                return;
            }
            if (this.serviceDispatch(action, Operation.Update, this.updateServlet)) {
                return;
            }
            if (this.serviceDispatch(action, Operation.Upload, this.uploadServlet)) {
                return;
            }
            if (hasParams) {
                if (this.serviceDispatch(action, Operation.GSP_R, this.gspServlet_R)) {
                    return;
                }
                if (this.serviceDispatch(action, Operation.GSP_RW, this.gspServlet_RW)) {
                    return;
                }
            } else {
                if (this.serviceDispatch(action, Operation.GSP_R, this.restQuads_R)) {
                    return;
                }
                if (this.serviceDispatch(action, Operation.GSP_RW, this.restQuads_RW)) {
                    return;
                }
            }
            if (this.serviceDispatch(action, Operation.Quads_RW, this.restQuads_RW)) {
                return;
            }
            if (this.serviceDispatch(action, Operation.Quads_R, this.restQuads_R)) {
                return;
            }
        }
        if (hasParams) {
            ServletOps.errorNotFound("Not found: dataset='" + this.printName(desc.getName()) + "' service='" + this.printName(trailing) + "' query string=?" + qs);
        }
        ServletOps.errorNotFound("Not found: dataset='" + this.printName(desc.getName()) + "' service='" + this.printName(trailing) + "'");
        this.doGraphStoreProtocol(action);
    }

    private boolean serviceDispatch(HttpAction action, Operation operation, ActionService servlet) {
        Endpoint endpoint = action.getEndpoint();
        if (endpoint == null) {
            return false;
        }
        if (!endpoint.isType(operation)) {
            return false;
        }
        this.executeRequest(action, servlet);
        return true;
    }

    private String printName(String x) {
        if (x.startsWith("/")) {
            return x.substring(1);
        }
        return x;
    }

    private void doGraphStoreProtocol(HttpAction action) {
        Endpoint operation = action.getEndpoint();
        String method = action.request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            if (!this.allowREST_R(action)) {
                ServletOps.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Read operation : " + method);
            }
            this.executeRequest(action, this.gspServlet_R);
            return;
        }
        if (!this.allowREST_W(action)) {
            ServletOps.errorForbidden("Forbidden: SPARQL Graph Store Protocol : " + method);
        }
        this.executeRequest(action, this.gspServlet_RW);
    }

    private void executeRequest(HttpAction action, ActionService servlet) {
        servlet.executeLifecycle(action);
    }

    protected static MediaType contentNegotationQuads(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    protected String findTrailing(String uri, String dsname) {
        if (dsname.length() >= uri.length()) {
            return "";
        }
        return uri.substring(dsname.length() + 1);
    }

    @Override
    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    public static class AccessByConfig
    extends SPARQL_UberServlet_Original {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return this.isEnabled(action, Operation.Query);
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return this.isEnabled(action, Operation.Update);
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return this.isEnabled(action, Operation.GSP_R) || this.isEnabled(action, Operation.GSP_RW);
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return this.isEnabled(action, Operation.GSP_RW);
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return this.isEnabled(action, Operation.Quads_R) || this.isEnabled(action, Operation.Quads_RW);
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return this.isEnabled(action, Operation.Quads_RW);
        }

        private boolean isEnabled(HttpAction action, Operation operation) {
            DataService dSrv = action.getDataService();
            if (dSrv == null) {
                return false;
            }
            return !dSrv.getEndpoints(operation).isEmpty();
        }
    }

    public static class ReadWrite
    extends SPARQL_UberServlet_Original {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return true;
        }
    }

    public static class ReadOnly
    extends SPARQL_UberServlet_Original {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return false;
        }
    }
}

