/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class SPARQL_Update
extends SPARQL_Protocol {
    private static final String UpdateParseBase = "http://server/unset-base/";
    private static final IRIResolver resolver = IRIResolver.create("http://server/unset-base/");
    protected static List<String> paramsForm = Arrays.asList("request", "update", "using-graph-uri", "using-named-graph-uri");
    protected static List<String> paramsPOST = Arrays.asList("using-graph-uri", "using-named-graph-uri");

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(400, "Attempt to perform SPARQL update by GET.  Use POST");
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Update.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    protected void doOptions(HttpAction action) {
        this.doOptions(action.request, action.response);
    }

    @Override
    protected void perform(HttpAction action) {
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null) {
            ct = WebContent.ctSPARQLUpdate;
        }
        if (WebContent.matchContentType(WebContent.ctSPARQLUpdate, ct)) {
            this.executeBody(action);
            return;
        }
        if (WebContent.isHtmlForm(ct)) {
            this.executeForm(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + action.request.getContentType());
    }

    @Override
    protected void validate(HttpAction action) {
        ContentType ct;
        HttpServletRequest request = action.request;
        if ("OPTIONS".equals(request.getMethod())) {
            return;
        }
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            ServletOps.errorMethodNotAllowed("SPARQL Update : use POST");
        }
        if ((ct = FusekiLib.getContentType(action)) == null) {
            ct = WebContent.ctSPARQLUpdate;
        }
        if (WebContent.matchContentType(WebContent.ctSPARQLUpdate, ct)) {
            String charset = request.getCharacterEncoding();
            if (charset != null && !charset.equalsIgnoreCase("utf-8")) {
                ServletOps.errorBadRequest("Bad charset: " + charset);
            }
            this.validate(action, paramsPOST);
            return;
        }
        if (WebContent.isHtmlForm(ct)) {
            String requestStr;
            int x = SPARQL_Update.countParamOccurences(request, "update") + SPARQL_Update.countParamOccurences(request, "request");
            if (x == 0) {
                ServletOps.errorBadRequest("SPARQL Update: No 'update=' parameter");
            }
            if (x != 1) {
                ServletOps.errorBadRequest("SPARQL Update: Multiple 'update=' parameters");
            }
            if ((requestStr = request.getParameter("update")) == null) {
                requestStr = request.getParameter("request");
            }
            if (requestStr == null) {
                ServletOps.errorBadRequest("SPARQL Update: No update= in HTML form");
            }
            this.validate(action, paramsForm);
            return;
        }
        ServletOps.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded (got " + ct.getContentType() + ")");
    }

    protected void validate(HttpAction action, Collection<String> params) {
        if (params != null) {
            Enumeration<String> en = action.request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Update: Unrecognized request parameter (ignored): " + name);
            }
        }
    }

    private void executeBody(HttpAction action) {
        InputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        if (action.verbose) {
            byte[] bytes = IO.readWholeFile(input);
            input = new ByteArrayInputStream(bytes);
            try {
                String requestStr = Bytes.bytes2string(bytes);
                action.log.info(String.format("[%d] Update = %s", action.id, ServletOps.formatForLog(requestStr)));
            }
            catch (Exception ex) {
                action.log.info(String.format("[%d] Update = <failed to decode>", action.id));
            }
        }
        this.execute(action, input);
        ServletOps.successNoContent(action);
    }

    private void executeForm(HttpAction action) {
        String requestStr = action.request.getParameter("update");
        if (requestStr == null) {
            requestStr = action.request.getParameter("request");
        }
        if (action.verbose) {
            action.log.info(String.format("[%d] Form update = \n%s", action.id, requestStr));
        }
        byte[] b = StrUtils.asUTF8bytes(requestStr);
        ByteArrayInputStream input = new ByteArrayInputStream(b);
        requestStr = null;
        this.execute(action, input);
        ServletOps.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpAction action, InputStream input) {
        block18: {
            if (action.request.getMethod().equals("OPTIONS")) {
                this.doOptions(action);
                return;
            }
            UsingList usingList = this.processProtocol(action.request);
            UpdateRequest req = null;
            if (!action.isTransactional()) {
                try {
                    req = UpdateFactory.read(usingList, input, UpdateParseBase, Syntax.syntaxARQ);
                }
                catch (UpdateException ex) {
                    ServletOps.errorBadRequest(ex.getMessage());
                    return;
                }
                catch (QueryParseException ex) {
                    ServletOps.errorBadRequest(SPARQL_Update.messageForQueryException(ex));
                    return;
                }
            }
            action.beginWrite();
            try {
                if (req == null) {
                    UpdateAction.parseExecute(usingList, action.getActiveDSG(), input, UpdateParseBase, Syntax.syntaxARQ);
                } else {
                    UpdateAction.execute(req, action.getActiveDSG());
                }
                action.commit();
            }
            catch (UpdateException ex) {
                action.abort();
                SPARQL_Update.incCounter(action.getEndpoint().getCounters(), CounterName.UpdateExecErrors);
                ServletOps.errorOccurred(ex.getMessage());
            }
            catch (QueryBuildException | QueryParseException ex) {
                action.abort();
                ServletOps.errorBadRequest(SPARQL_Update.messageForQueryException(ex));
            }
            catch (Throwable ex) {
                if (ex instanceof ActionErrorException) break block18;
                try {
                    action.abort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ServletOps.errorOccurred(ex.getMessage(), ex);
            }
            finally {
                action.endWrite();
            }
        }
    }

    private UsingList processProtocol(HttpServletRequest request) {
        UsingList toReturn = new UsingList();
        String[] usingArgs = request.getParameterValues("using-graph-uri");
        String[] usingNamedArgs = request.getParameterValues("using-named-graph-uri");
        if (usingArgs == null && usingNamedArgs == null) {
            return toReturn;
        }
        if (usingArgs == null) {
            usingArgs = new String[]{};
        }
        if (usingNamedArgs == null) {
            usingNamedArgs = new String[]{};
        }
        for (String nodeUri : usingArgs) {
            toReturn.addUsing(SPARQL_Update.createNode(nodeUri));
        }
        for (String nodeUri : usingNamedArgs) {
            toReturn.addUsingNamed(SPARQL_Update.createNode(nodeUri));
        }
        return toReturn;
    }

    private static Node createNode(String x) {
        try {
            IRI iri2 = resolver.resolve(x);
            return NodeFactory.createURI(iri2.toString());
        }
        catch (Exception ex) {
            ServletOps.errorBadRequest("SPARQL Update: bad IRI: " + x);
            return null;
        }
    }
}

