/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;

public class SPARQL_Upload
extends ActionService {
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Upload.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void validate(HttpAction action) {
    }

    @Override
    protected void perform(HttpAction action) {
        boolean isMultipart = ServletFileUpload.isMultipartContent(action.request);
        if (!isMultipart) {
            ServletOps.error(400, "Not a file upload");
        }
        long count = SPARQL_Upload.upload(action, "http://server/unset-base/");
        ServletOps.success(action);
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            out.println("<p>");
            out.println("Triples = " + count + "\n");
            out.println("<p>");
            out.println("</p>");
            out.println("<button onclick=\"timeFunction()\">Back to Fuseki</button>");
            out.println("</p>");
            out.println("<script type=\"text/javascript\">");
            out.println("function timeFunction(){");
            out.println("window.location.href = \"/fuseki.html\";}");
            out.println("</script>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
            ServletOps.success(action);
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static long upload(HttpAction action, String base) {
        if (action.isTransactional()) {
            return SPARQL_Upload.uploadTxn(action, base);
        }
        return SPARQL_Upload.uploadNonTxn(action, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long uploadNonTxn(HttpAction action, String base) {
        UploadDetails upload = SPARQL_Upload.uploadWorker(action, base);
        String graphName = upload.graphName;
        DatasetGraph dataTmp = upload.data;
        long count = upload.count;
        if (graphName == null) {
            action.log.info(String.format("[%d] Upload: %d Quads(s)", action.id, count));
        } else {
            action.log.info(String.format("[%d] Upload: Graph: %s, %d triple(s)", action.id, graphName, count));
        }
        Node gn = null;
        if (graphName != null) {
            gn = graphName.equals("default") ? Quad.defaultGraphNodeGenerated : NodeFactory.createURI(graphName);
        }
        action.beginWrite();
        try {
            if (gn != null) {
                FusekiLib.addDataInto(dataTmp.getDefaultGraph(), action.getActiveDSG(), gn);
            } else {
                FusekiLib.addDataInto(dataTmp, action.getActiveDSG());
            }
            action.commit();
            long l = count;
            return l;
        }
        catch (RuntimeException ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
            long l = -1L;
            return l;
        }
        finally {
            action.endWrite();
        }
    }

    private static long uploadTxn(HttpAction action, String base) {
        return SPARQL_Upload.uploadNonTxn(action, base);
    }

    private static UploadDetails uploadWorker(HttpAction action, String base) {
        DatasetGraph dsgTmp = DatasetGraphFactory.create();
        ServletFileUpload upload = new ServletFileUpload();
        String graphName = null;
        boolean isQuads = false;
        long count = -1L;
        String name = null;
        ContentType ct = null;
        Lang lang = null;
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String contentTypeHeader;
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString(stream, "UTF-8");
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("") || graphName.equals("default")) continue;
                        IRI iri2 = IRIResolver.parseIRI(value);
                        if (iri2.hasViolation(false)) {
                            ServletOps.errorBadRequest("Bad IRI: " + graphName);
                        }
                        if (iri2.getScheme() == null) {
                            ServletOps.errorBadRequest("Bad IRI: no IRI scheme name: " + graphName);
                        }
                        if (!iri2.getScheme().equalsIgnoreCase("http") && !iri2.getScheme().equalsIgnoreCase("https")) continue;
                        if (iri2.getRawHost() == null) {
                            ServletOps.errorBadRequest("Bad IRI: no host name: " + graphName);
                        }
                        if (iri2.getRawPath() == null || iri2.getRawPath().length() == 0) {
                            ServletOps.errorBadRequest("Bad IRI: no path: " + graphName);
                        }
                        if (iri2.getRawPath().charAt(0) == '/') continue;
                        ServletOps.errorBadRequest("Bad IRI: Path does not start '/': " + graphName);
                        continue;
                    }
                    if (fieldName.equals("default-graph-uri")) {
                        graphName = null;
                        continue;
                    }
                    action.log.info(String.format("[%d] Upload: Field=%s ignored", action.id, fieldName));
                    continue;
                }
                name = item.getName();
                if (name == null || name.equals("") || name.equals("UNSET FILE NAME")) {
                    ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
                }
                if ((lang = RDFLanguages.contentTypeToLang((ct = ContentType.create(contentTypeHeader = item.getContentType())).getContentType())) == null) {
                    lang = RDFLanguages.filenameToLang(name);
                    if (name.endsWith(".gz")) {
                        stream = new GZIPInputStream(stream);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                isQuads = RDFLanguages.isQuads(lang);
                action.log.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => %s", action.id, name, ct.getContentType(), ct.getCharset(), lang.getName()));
                StreamRDF x = StreamRDFLib.dataset(dsgTmp);
                StreamRDFCounting dest = StreamRDFLib.count(x);
                ActionLib.parse(action, dest, stream, lang, base);
                count = dest.count();
            }
            if (graphName == null || graphName.equals("")) {
                graphName = "default";
            }
            if (isQuads) {
                graphName = null;
            }
            return new UploadDetails(graphName, dsgTmp, count);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex);
            return null;
        }
    }

    static class UploadDetails {
        final String graphName;
        final DatasetGraph data;
        final long count;

        UploadDetails(String gn, DatasetGraph dsg, long parserCount) {
            this.graphName = gn;
            this.data = dsg;
            this.count = parserCount;
        }
    }
}

