/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.UploadDetails;

public class ServletOps {
    public static void responseSendError(HttpServletResponse response, int statusCode, String message) {
        try {
            response.sendError(statusCode, message);
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void responseSendError(HttpServletResponse response, int statusCode) {
        try {
            response.sendError(statusCode);
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void successNoContent(HttpAction action) {
        ServletOps.success(action, 204);
    }

    public static void success(HttpAction action) {
        ServletOps.success(action, 200);
    }

    public static void successCreated(HttpAction action) {
        ServletOps.success(action, 201);
    }

    public static void successNotFound(HttpAction action) {
        ServletOps.success(action, 404);
    }

    public static void success(HttpAction action, int httpStatusCode) {
        action.response.setStatus(httpStatusCode);
    }

    public static void successPage(HttpAction action, String message) {
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            if (message != null) {
                out.println("<p>");
                out.println(message);
                out.println("</p>");
            }
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void warning(HttpAction action, String string) {
        action.log.warn(string);
    }

    public static void warning(HttpAction action, String string, Throwable thorwable) {
        action.log.warn(string, thorwable);
    }

    public static void errorBadRequest(String string) {
        ServletOps.error(400, string);
    }

    public static void errorNotFound(String string) {
        ServletOps.error(404, string);
    }

    public static void errorNotImplemented(String msg) {
        ServletOps.error(501, msg);
    }

    public static void errorMethodNotAllowed(String method) {
        ServletOps.errorMethodNotAllowed(method, "HTTP method not allowed: " + method);
    }

    public static void errorMethodNotAllowed(String method, String msg) {
        ServletOps.error(405, msg);
    }

    public static void errorForbidden() {
        ServletOps.error(403, "Forbidden");
    }

    public static void errorForbidden(String msg) {
        if (msg != null) {
            ServletOps.error(403, msg);
        } else {
            ServletOps.errorForbidden();
        }
    }

    public static void error(int statusCode) {
        throw new ActionErrorException(null, null, statusCode);
    }

    public static void error(int statusCode, String string) {
        throw new ActionErrorException(null, string, statusCode);
    }

    public static void errorOccurred(String message) {
        ServletOps.errorOccurred(message, null);
    }

    public static void errorOccurred(Throwable ex) {
        ServletOps.errorOccurred(null, ex);
    }

    public static void errorOccurred(String message, Throwable ex) {
        throw new ActionErrorException(ex, message, 500);
    }

    public static String formatForLog(String string) {
        if (string == null) {
            return "<null>";
        }
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        return string;
    }

    public static void setNoCache(HttpAction action) {
        ServletOps.setNoCache(action.response);
    }

    public static void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setHeader("Pragma", "no-cache");
    }

    public static void sendJsonReponse(HttpAction action, JsonValue v) {
        if (v == null) {
            ServletOps.success(action);
            return;
        }
        ServletOps.success(action);
        ServletOps.sendJson(action, v);
    }

    public static void sendJson(HttpAction action, JsonValue v) {
        if (v == null) {
            return;
        }
        try {
            HttpServletResponseTracker response = action.response;
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            JSON.write(out, v);
            out.println();
            out.flush();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void uploadResponse(HttpAction action, UploadDetails details) {
        if (details.getExistedBefore().equals((Object)UploadDetails.PreState.ABSENT)) {
            ServletOps.successCreated(action);
        } else {
            ServletOps.success(action);
        }
        JsonValue v = details.detailsJson();
        ServletOps.sendJson(action, v);
    }
}

