/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;

public abstract class ValidatorBase
extends ServletBase {
    private static Logger vLog = Fuseki.validationLog;
    public static final String contentTypeHTML = "text/html";
    public static final AcceptList jsonOrTextOffer = AcceptList.create("text/html", "application/json");
    public static final ContentType dftContentType = ContentType.create("text/html");

    @Override
    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    @Override
    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    protected abstract void executeHTML(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void executeJSON(HttpServletRequest var1, HttpServletResponse var2);

    protected void executeJSON(HttpServletRequest request, HttpServletResponse response, JsonAction jsonAction) {
        long id = ValidatorBase.allocRequestId(request, response);
        ValidationAction action = new ValidationAction(id, vLog, request, response, false);
        ValidatorBase.printRequest(action);
        action.setStartTime();
        response = action.response;
        ValidatorBase.initResponse(request, response);
        try {
            JsonObject obj = jsonAction.execute(action);
            action.statusCode = 200;
            action.message = "OK";
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            action.response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            JSON.write(out, (JsonValue)obj);
        }
        catch (ActionErrorException ex) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(System.err);
            }
            if (ex.getMessage() != null) {
                ServletOps.responseSendError(response, ex.getRC(), ex.getMessage());
            } else {
                ServletOps.responseSendError(response, ex.getRC());
            }
        }
        catch (Throwable th) {
            ServletOps.responseSendError(response, 500, "Internal Error");
        }
        action.setFinishTime();
        ValidatorBase.printResponse(action);
    }

    static void initResponse(HttpServletRequest request, HttpServletResponse response) {
        ValidatorBase.setCommonHeaders(response);
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            ValidatorBase.setVaryHeader(response);
        }
    }

    protected void execute(HttpServletRequest request, HttpServletResponse response) {
        MediaType mt = ConNeg.chooseContentType(request, jsonOrTextOffer, null);
        if (mt != null && mt.equals(DEF.acceptJSON)) {
            this.executeJSON(request, response);
        } else {
            this.executeHTML(request, response);
        }
    }

    static void printRequest(ValidationAction action) {
        String url = ActionLib.wholeRequestURL(action.request);
        String method = action.request.getMethod();
        action.log.info(String.format("[%d] %s %s", action.id, method, url));
        if (action.verbose) {
            Enumeration<String> en = action.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = en.nextElement();
                Enumeration<String> vals = action.request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    action.log.info(String.format("[%d]   %s", action.id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    action.log.info(String.format("[%d]   %-20s %s", action.id, h, vals.nextElement()));
                }
            }
        }
    }

    static void printResponse(ValidationAction action) {
        long time = action.getTime();
        if (action.verbose) {
            // empty if block
        }
        String timeStr = ValidatorBase.fmtMillis(time);
        if (action.message == null) {
            action.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, HttpSC.getMessage(action.statusCode), timeStr));
        } else {
            action.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, action.message, timeStr));
        }
    }

    static String fmtMillis(long time) {
        if (time < 1000L) {
            return String.format("%,d ms", time);
        }
        return String.format("%,.3f s", (double)time / 1000.0);
    }

    public static interface JsonAction {
        public JsonObject execute(ValidationAction var1);
    }
}

