/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.spatial.DatasetGraphSpatial;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialDocProducerTriples;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexLucene;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.assembler.SpatialVocab;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.system.JenaSystem;
import org.apache.lucene.store.Directory;

public class SpatialDatasetFactory {
    public static Dataset create(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, SpatialVocab.spatialDataset);
    }

    public static Dataset create(Dataset base, SpatialIndex textIndex) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = SpatialDatasetFactory.create(dsg, textIndex);
        return DatasetFactory.wrap(dsg);
    }

    public static DatasetGraph create(DatasetGraph dsg, SpatialIndex spatialIndex) {
        SpatialDocProducerTriples producer = new SpatialDocProducerTriples(spatialIndex);
        DatasetGraphSpatial dsgt = new DatasetGraphSpatial(dsg, spatialIndex, producer);
        dsgt.getContext().set(SpatialQuery.spatialIndex, spatialIndex);
        return dsgt;
    }

    public static SpatialIndex createLuceneIndex(Directory directory, EntityDefinition entMap) {
        SpatialIndexLucene index = new SpatialIndexLucene(directory, entMap);
        return index;
    }

    public static Dataset createLucene(Dataset base, Directory directory, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createLuceneIndex(directory, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, EntityDefinition entMap) {
        SpatialIndex index = SpatialDatasetFactory.createLuceneIndex(directory, entMap);
        return SpatialDatasetFactory.create(base, index);
    }

    static {
        JenaSystem.init();
    }
}

