/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialPredicatePair;
import org.apache.jena.query.spatial.SpatialPredicatePairValue;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.SpatialQueryFuncs;
import org.apache.jena.query.spatial.SpatialValueUtil;
import org.locationtech.spatial4j.shape.Shape;

public class SpatialIndexContext {
    private final EntityDefinition defn;
    private final SpatialIndex indexer;
    private final Map<String, Set<SpatialPredicatePairValue>> spatialPredicatePairValues;

    public SpatialIndexContext(SpatialIndex indexer) {
        this.defn = indexer.getDocDef();
        this.indexer = indexer;
        this.spatialPredicatePairValues = new HashMap<String, Set<SpatialPredicatePairValue>>();
    }

    public void index(Node g, Node s, Node p, Node o) {
        if (!o.isLiteral()) {
            return;
        }
        String x = SpatialQueryFuncs.subjectToString(s);
        Log.info(this.getClass(), "Subject: " + x);
        if (this.defn.isSpatialPredicate(p) && SpatialValueUtil.isDecimal(o)) {
            boolean isLat = this.defn.isLatitudePredicate(p);
            SpatialPredicatePair pair = this.defn.getSpatialPredicatePair(p);
            Set<SpatialPredicatePairValue> pairValues = this.spatialPredicatePairValues.get(x);
            if (pairValues == null) {
                pairValues = new HashSet<SpatialPredicatePairValue>();
                this.spatialPredicatePairValues.put(x, pairValues);
            }
            Iterator<SpatialPredicatePairValue> it = pairValues.iterator();
            SpatialPredicatePairValue toRemove = null;
            while (it.hasNext()) {
                SpatialPredicatePairValue pairValue = it.next();
                if (!pairValue.getPair().equals(pair)) continue;
                Double theOtherValue = pairValue.getTheOtherValue(p);
                if (theOtherValue == null) break;
                if (isLat) {
                    this.indexer.add(x, SpatialQuery.ctx.makePoint(theOtherValue, Double.parseDouble(o.getLiteralLexicalForm())));
                } else {
                    this.indexer.add(x, SpatialQuery.ctx.makePoint(Double.parseDouble(o.getLiteralLexicalForm()), theOtherValue));
                }
                toRemove = pairValue;
                break;
            }
            if (toRemove != null) {
                pairValues.remove(toRemove);
                return;
            }
            SpatialPredicatePairValue toAdd = new SpatialPredicatePairValue(pair);
            toAdd.setValue(p, Double.parseDouble(o.getLiteralLexicalForm()));
            pairValues.add(toAdd);
        } else if (this.defn.isWKTPredicate(p) && SpatialValueUtil.isWKTLiteral(o.getLiteral())) {
            Shape shape = SpatialQuery.ctx.readShape(o.getLiteralLexicalForm());
            this.indexer.add(x, shape);
        }
    }
}

