/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.SpatialQueryFuncs;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.store.Directory;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexLucene
implements SpatialIndex {
    private static Logger log = LoggerFactory.getLogger(SpatialIndexLucene.class);
    private static int MAX_N = 10000;
    public static final FieldType ftIRI = new FieldType();
    private final EntityDefinition docDef;
    private final Directory directory;
    private IndexWriter indexWriter;
    private Analyzer analyzer = new StandardAnalyzer();
    private SpatialStrategy strategy;

    public SpatialIndexLucene(Directory directory, EntityDefinition def) {
        this.directory = directory;
        this.docDef = def;
        int maxLevels = 11;
        GeohashPrefixTree grid = new GeohashPrefixTree(SpatialQuery.ctx, maxLevels);
        this.strategy = new RecursivePrefixTreeStrategy(grid, def.getGeoField());
        this.startIndexing();
        this.finishIndexing();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void startIndexing() {
        try {
            IndexWriterConfig wConfig = new IndexWriterConfig(this.analyzer);
            this.indexWriter = new IndexWriter(this.directory, wConfig);
        }
        catch (IndexFormatTooOldException e2) {
            throw new SpatialIndexException("jena-spatial/Lucene cannot use indexes created before Jena 3.3.0. Please rebuild your spatial index using jena.spatialindexer from Jena 3.3.0 or above.", e2);
        }
        catch (IOException e3) {
            SpatialIndexLucene.exception(e3);
        }
    }

    @Override
    public void finishIndexing() {
        try {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.indexWriter = null;
        }
        catch (IOException e2) {
            SpatialIndexLucene.exception(e2);
        }
    }

    @Override
    public void abortIndexing() {
        try {
            this.indexWriter.rollback();
        }
        catch (IOException ex) {
            SpatialIndexLucene.exception(ex);
        }
    }

    @Override
    public void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException ex) {
                SpatialIndexLucene.exception(ex);
            }
        }
    }

    @Override
    public void add(String entityURI, Shape ... shapes) {
        try {
            boolean autoBatch = this.indexWriter == null;
            Document doc = this.doc(entityURI, shapes);
            if (autoBatch) {
                this.startIndexing();
            }
            this.indexWriter.addDocument(doc);
            if (autoBatch) {
                this.finishIndexing();
            }
        }
        catch (IOException e2) {
            SpatialIndexLucene.exception(e2);
        }
    }

    private Document doc(String entityURI, Shape ... shapes) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), entityURI, ftIRI);
        doc.add(entField);
        for (Shape shape : shapes) {
            for (Field f : this.strategy.createIndexableFields(shape)) {
                doc.add(f);
            }
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Node> query(Shape shape, int limit, SpatialOperation operation) {
        try (DirectoryReader indexReader = DirectoryReader.open(this.directory);){
            List<Node> list = this.query$(indexReader, shape, limit, operation);
            return list;
        }
        catch (Exception ex) {
            SpatialIndexLucene.exception(ex);
            return null;
        }
    }

    private List<Node> query$(IndexReader indexReader, Shape shape, int limit, SpatialOperation operation) throws IOException {
        if (limit <= 0) {
            limit = MAX_N;
        }
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        SpatialArgs args = new SpatialArgs(operation, shape);
        args.setDistErr(0.0);
        Query query2 = this.strategy.makeQuery(args);
        TopDocs docs = indexSearcher.search(query2, limit);
        ArrayList<Node> results = new ArrayList<Node>();
        for (ScoreDoc sd : docs.scoreDocs) {
            String[] values;
            Document doc = indexSearcher.doc(sd.doc);
            for (String v : values = doc.getValues(this.docDef.getEntityField())) {
                Node n = SpatialQueryFuncs.stringToNode(v);
                results.add(n);
            }
        }
        return results;
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private static void exception(Exception ex) {
        throw new SpatialIndexException(ex);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexOptions(IndexOptions.DOCS);
        ftIRI.freeze();
    }
}

