/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import org.apache.jena.query.spatial.assembler.SpatialAssembler;
import org.apache.jena.query.spatial.pfunction.library.EastPF;
import org.apache.jena.query.spatial.pfunction.library.IntersectsBoxPF;
import org.apache.jena.query.spatial.pfunction.library.IsNearByPF;
import org.apache.jena.query.spatial.pfunction.library.IsWithinBoxPF;
import org.apache.jena.query.spatial.pfunction.library.IsWithinCirclePF;
import org.apache.jena.query.spatial.pfunction.library.NorthPF;
import org.apache.jena.query.spatial.pfunction.library.SouthPF;
import org.apache.jena.query.spatial.pfunction.library.WestPF;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.lib.Metadata;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.system.JenaSystem;
import org.locationtech.spatial4j.context.SpatialContext;

public class SpatialQuery {
    private static volatile boolean initialized = false;
    private static Object lock = new Object();
    public static String NS = "http://jena.apache.org/spatial#";
    public static String IRI = "http://jena.apache.org/#spatial";
    public static final Symbol spatialIndex = Symbol.create(NS + "index");
    public static final String PATH = "org.apache.jena.query.spatial";
    private static String metadataLocation = "org/apache/jena/query/spatial/properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ Spatial Query";
    public static final String VERSION = metadata.get("org.apache.jena.query.spatial.version", "unknown");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.query.spatial.build.datetime", "unset");
    public static SpatialContext ctx = SpatialContext.GEO;
    public static final String JTS_SPATIAL_CONTEXT_FACTORY_CLASS = "org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle("SpatialQuery.init - skip", new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle("SpatialQuery.init - start", new Object[0]);
            SpatialAssembler.init();
            SystemInfo sysInfo = new SystemInfo(IRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem(sysInfo);
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#withinCircle", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsWithinCirclePF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#nearby", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsNearByPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#withinBox", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IsWithinBoxPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#intersectBox", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new IntersectsBoxPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#north", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new NorthPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#south", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new SouthPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#east", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new EastPF();
                }
            });
            PropertyFunctionRegistry.get().put("http://jena.apache.org/spatial#west", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new WestPF();
                }
            });
            JenaSystem.logLifecycle("SpatialQuery.init - finish", new Object[0]);
        }
    }

    static {
        JenaSystem.init();
    }
}

